/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueLookAndFeel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSliderUI;

public class BlueSliderUI
extends MetalSliderUI {
    public static ComponentUI createUI(JComponent c) {
        return new BlueSliderUI();
    }

    @Override
    public void paintTrack(Graphics g) {
        ColorUIResource trackColor = !this.slider.isEnabled() ? BlueLookAndFeel.getControlShadow() : this.slider.getForeground();
        boolean leftToRight = this.slider.getComponentOrientation().isLeftToRight();
        g.translate(this.trackRect.x, this.trackRect.y);
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(BlueLookAndFeel.getBlack());
        g2d.fillRoundRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop - 1, 6, 6);
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }
}

