/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

class BlueSplitPaneDivider
extends BasicSplitPaneDivider {
    private int inset = 2;
    private int dividerRestoreLocation = 0;
    private Color controlColor = MetalLookAndFeel.getControl();
    private Color primaryControlColor = MetalLookAndFeel.getPrimaryControl();

    public BlueSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setLayout(new BlueDividerLayout());
        this.setBorder(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    BlueSplitPaneDivider.this.handleDoubleClick();
                }
            }
        });
    }

    protected void handleDoubleClick() {
        JSplitPane jsp = this.getSplitPaneFromSuper();
        int currentLoc = jsp.getDividerLocation();
        if (currentLoc == jsp.getMinimumDividerLocation() || currentLoc == jsp.getMaximumDividerLocation()) {
            jsp.setDividerLocation(this.dividerRestoreLocation);
        } else {
            this.dividerRestoreLocation = currentLoc;
            if (currentLoc - jsp.getMinimumDividerLocation() < jsp.getMaximumDividerLocation() - currentLoc) {
                jsp.setDividerLocation(jsp.getMinimumDividerLocation());
            } else {
                jsp.setDividerLocation(jsp.getMaximumDividerLocation());
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.splitPane.hasFocus()) {
            g.setColor(this.primaryControlColor);
        } else {
            g.setColor(this.controlColor);
        }
        Rectangle clip = g.getClipBounds();
        Insets insets = this.getInsets();
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        Dimension size = this.getSize();
        size.width -= this.inset * 2;
        size.height -= this.inset * 2;
        int drawX = this.inset;
        int drawY = this.inset;
        if (insets != null) {
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            drawX += insets.left;
            drawY += insets.top;
        }
        super.paint(g);
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){
            int[][] buffer = new int[][]{{0, 0, 0, 2, 2, 0, 0, 0, 0}, {0, 0, 2, 1, 1, 1, 0, 0, 0}, {0, 2, 1, 1, 1, 1, 1, 0, 0}, {2, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 3, 3, 3, 3, 3, 3, 3, 3}};

            @Override
            public void setBorder(Border b) {
            }

            @Override
            public void paint(Graphics g) {
                block7: {
                    JSplitPane splitPane = BlueSplitPaneDivider.this.getSplitPaneFromSuper();
                    if (splitPane == null) break block7;
                    int oneTouchSize = BlueSplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int orientation = BlueSplitPaneDivider.this.getOrientationFromSuper();
                    int blockSize = Math.min(BlueSplitPaneDivider.this.getDividerSize(), oneTouchSize);
                    Color[] colors = new Color[]{this.getBackground(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight()};
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (this.getModel().isPressed()) {
                        colors[1] = colors[2];
                    }
                    if (orientation == 0) {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(i, j, i, j);
                            }
                        }
                    } else {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(j, i, j, i);
                            }
                        }
                    }
                }
            }

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        return b;
    }

    @Override
    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){
            int[][] buffer = new int[][]{{2, 2, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 1, 1, 1, 1, 3}, {0, 0, 1, 1, 1, 1, 3, 0}, {0, 0, 0, 1, 1, 3, 0, 0}, {0, 0, 0, 0, 3, 0, 0, 0}};

            @Override
            public void setBorder(Border border) {
            }

            @Override
            public void paint(Graphics g) {
                block7: {
                    JSplitPane splitPane = BlueSplitPaneDivider.this.getSplitPaneFromSuper();
                    if (splitPane == null) break block7;
                    int oneTouchSize = BlueSplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int orientation = BlueSplitPaneDivider.this.getOrientationFromSuper();
                    int blockSize = Math.min(BlueSplitPaneDivider.this.getDividerSize(), oneTouchSize);
                    Color[] colors = new Color[]{this.getBackground(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight()};
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (this.getModel().isPressed()) {
                        colors[1] = colors[2];
                    }
                    if (orientation == 0) {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(i, j, i, j);
                            }
                        }
                    } else {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < blockSize; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                g.setColor(colors[this.buffer[j - 1][i - 1]]);
                                g.drawLine(j, i, j, i);
                            }
                        }
                    }
                }
            }

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    int getOneTouchSizeFromSuper() {
        return 6;
    }

    int getOneTouchOffsetFromSuper() {
        return 2;
    }

    int getOrientationFromSuper() {
        return this.orientation;
    }

    JSplitPane getSplitPaneFromSuper() {
        return this.splitPane;
    }

    JButton getLeftButtonFromSuper() {
        return this.leftButton;
    }

    JButton getRightButtonFromSuper() {
        return this.rightButton;
    }

    public class BlueDividerLayout
    implements LayoutManager {
        @Override
        public void layoutContainer(Container c) {
            JButton leftButton = BlueSplitPaneDivider.this.getLeftButtonFromSuper();
            JButton rightButton = BlueSplitPaneDivider.this.getRightButtonFromSuper();
            JSplitPane splitPane = BlueSplitPaneDivider.this.getSplitPaneFromSuper();
            int orientation = BlueSplitPaneDivider.this.getOrientationFromSuper();
            int oneTouchSize = BlueSplitPaneDivider.this.getOneTouchSizeFromSuper();
            int oneTouchOffset = BlueSplitPaneDivider.this.getOneTouchOffsetFromSuper();
            Insets insets = BlueSplitPaneDivider.this.getInsets();
            if (leftButton != null && rightButton != null && c == BlueSplitPaneDivider.this) {
                if (splitPane.isOneTouchExpandable()) {
                    if (orientation == 0) {
                        int extraY = insets != null ? insets.top : 0;
                        int blockSize = BlueSplitPaneDivider.this.getDividerSize();
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                        }
                        blockSize = Math.min(blockSize, oneTouchSize);
                        leftButton.setBounds(oneTouchOffset, extraY, blockSize * 2, blockSize);
                        rightButton.setBounds(oneTouchOffset + oneTouchSize * 2, extraY, blockSize * 2, blockSize);
                    } else {
                        int extraX;
                        int blockSize = BlueSplitPaneDivider.this.getDividerSize();
                        int n = extraX = insets != null ? insets.left : 0;
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                        }
                        blockSize = Math.min(blockSize, oneTouchSize);
                        leftButton.setBounds(extraX, oneTouchOffset, blockSize, blockSize * 2);
                        rightButton.setBounds(extraX, oneTouchOffset + oneTouchSize * 2, blockSize, blockSize * 2);
                    }
                } else {
                    leftButton.setBounds(-5, -5, 1, 1);
                    rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(0, 0);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public void addLayoutComponent(String string, Component c) {
        }
    }
}

