/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.GradientInfo;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;

class Gradient {
    private GradientInfo info;
    private int perpendicularLength = 0;
    private WritableRaster raster;
    private HashMap<Integer, Raster> childRasterCache;

    Gradient(GradientInfo i) {
        this.info = i;
    }

    Raster getRaster(int parallelPos, int perpendicularLength, int parallelLength) {
        Integer key;
        Raster o;
        if (this.raster == null || this.perpendicularLength < perpendicularLength) {
            this.createRaster(perpendicularLength);
        }
        if ((o = this.childRasterCache.get(key = new Integer(parallelPos))) != null) {
            return o;
        }
        Raster r = this.info.isVertical ? this.raster.createChild(0, parallelPos, this.perpendicularLength, this.info.parallelLength - parallelPos, 0, 0, null) : this.raster.createChild(parallelPos, 0, this.info.parallelLength - parallelPos, this.perpendicularLength, 0, 0, null);
        this.childRasterCache.put(key, r);
        return r;
    }

    public void dispose() {
    }

    private void createRaster(int perpendicularLength) {
        int gradientWidth;
        int gradientHeight;
        if (this.info.isVertical) {
            gradientHeight = this.info.parallelLength;
            gradientWidth = this.perpendicularLength = perpendicularLength;
        } else {
            gradientWidth = this.info.parallelLength;
            gradientHeight = this.perpendicularLength = perpendicularLength;
        }
        int sa = this.info.startColor >> 24 & 0xFF;
        int sr = this.info.startColor >> 16 & 0xFF;
        int sg = this.info.startColor >> 8 & 0xFF;
        int sb = this.info.startColor & 0xFF;
        int da = (this.info.endColor >> 24 & 0xFF) - sa;
        int dr = (this.info.endColor >> 16 & 0xFF) - sr;
        int dg = (this.info.endColor >> 8 & 0xFF) - sg;
        int db = (this.info.endColor & 0xFF) - sb;
        this.raster = this.info.model.createCompatibleWritableRaster(gradientWidth, gradientHeight);
        Object c = null;
        int pl = this.info.parallelLength;
        for (int i = 0; i < pl; ++i) {
            int alpha;
            int factor;
            if (this.info.isAscending) {
                factor = 2 * (3 - i);
                alpha = i > 3 ? 0 : sa + 130 * factor / pl << 24;
            } else {
                factor = 2 * (4 - (pl - i));
                alpha = i < pl - 4 ? 0 : sa + 2 * factor * da / pl << 24;
            }
            c = this.info.model.getDataElements(alpha | sr + factor * dr / pl << 16 | sg + factor * dg / pl << 8 | sb + factor * db / pl, c);
            for (int j = 0; j < perpendicularLength; ++j) {
                if (this.info.isVertical) {
                    this.raster.setDataElements(j, i, c);
                    continue;
                }
                this.raster.setDataElements(i, j, c);
            }
        }
        this.childRasterCache = new HashMap();
    }
}

