/*
 * Decompiled with CFR 0.152.
 */
package de.congrace.exp4j;

import de.congrace.exp4j.CustomFunction;
import de.congrace.exp4j.CustomOperator;
import de.congrace.exp4j.FunctionSeparatorToken;
import de.congrace.exp4j.FunctionToken;
import de.congrace.exp4j.NumberToken;
import de.congrace.exp4j.OperatorToken;
import de.congrace.exp4j.ParenthesesToken;
import de.congrace.exp4j.Token;
import de.congrace.exp4j.UnknownFunctionException;
import de.congrace.exp4j.UnparsableExpressionException;
import de.congrace.exp4j.VariableToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Tokenizer {
    private final Set<String> variableNames;
    private final Map<String, CustomFunction> functions;
    private final Map<String, CustomOperator> operators;

    Tokenizer(Set<String> variableNames, Map<String, CustomFunction> functions, Map<String, CustomOperator> operators) {
        this.variableNames = variableNames;
        this.functions = functions;
        this.operators = operators;
    }

    private boolean isDigitOrDecimalSeparator(char c) {
        return Character.isDigit(c) || c == '.';
    }

    private boolean isNotationSeparator(char c) {
        return c == 'e' || c == 'E';
    }

    private boolean isVariable(String name) {
        if (this.variableNames != null) {
            for (String var : this.variableNames) {
                if (!name.equals(var)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFunction(String name) {
        return this.functions.containsKey(name);
    }

    private boolean isOperatorCharacter(char c) {
        for (String symbol : this.operators.keySet()) {
            if (symbol.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<Token> getTokens(String expression) throws UnparsableExpressionException, UnknownFunctionException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        char[] chars = expression.toCharArray();
        int openBraces = 0;
        int openCurly = 0;
        int openSquare = 0;
        Object var7_7 = null;
        for (int i = 0; i < chars.length; ++i) {
            void var7_21;
            int offset;
            char c = chars[i];
            if (c == ' ') continue;
            if (Character.isDigit(c)) {
                StringBuilder valueBuilder = new StringBuilder(1);
                valueBuilder.append(c);
                int numberLen = 1;
                boolean lastCharNotationSeparator = false;
                boolean notationSeparatorOccured = false;
                while (chars.length > i + numberLen) {
                    if (this.isDigitOrDecimalSeparator(chars[i + numberLen])) {
                        valueBuilder.append(chars[i + numberLen]);
                        lastCharNotationSeparator = false;
                    } else if (this.isNotationSeparator(chars[i + numberLen])) {
                        if (notationSeparatorOccured) {
                            throw new UnparsableExpressionException("Number can have only one notation separator 'e/E'");
                        }
                        valueBuilder.append(chars[i + numberLen]);
                        lastCharNotationSeparator = true;
                        notationSeparatorOccured = true;
                    } else {
                        if (!lastCharNotationSeparator || chars[i + numberLen] != '-' && chars[i + numberLen] != '+') break;
                        valueBuilder.append(chars[i + numberLen]);
                        lastCharNotationSeparator = false;
                    }
                    ++numberLen;
                }
                i += numberLen - 1;
                NumberToken numberToken = new NumberToken(valueBuilder.toString());
            } else if (Character.isLetter(c) || c == '_') {
                StringBuilder nameBuilder = new StringBuilder();
                nameBuilder.append(c);
                offset = 1;
                while (chars.length > i + offset && (Character.isLetter(chars[i + offset]) || Character.isDigit(chars[i + offset]) || chars[i + offset] == '_')) {
                    nameBuilder.append(chars[i + offset++]);
                }
                String name = nameBuilder.toString();
                if (this.isVariable(name)) {
                    i += offset - 1;
                    VariableToken variableToken = new VariableToken(name);
                } else {
                    if (!this.isFunction(name)) throw new UnparsableExpressionException(expression, c, i + 1);
                    i += offset - 1;
                    FunctionToken functionToken = new FunctionToken(name, this.functions.get(name));
                }
            } else if (c == ',') {
                FunctionSeparatorToken functionSeparatorToken = new FunctionSeparatorToken();
            } else if (this.isOperatorCharacter(c)) {
                StringBuilder symbolBuilder = new StringBuilder();
                symbolBuilder.append(c);
                offset = 1;
                while (chars.length > i + offset && this.isOperatorCharacter(chars[i + offset]) && this.isOperatorStart(symbolBuilder.toString() + chars[i + offset])) {
                    symbolBuilder.append(chars[i + offset]);
                    ++offset;
                }
                String symbol = symbolBuilder.toString();
                if (!this.operators.containsKey(symbol)) throw new UnparsableExpressionException(expression, c, i + 1);
                i += offset - 1;
                OperatorToken operatorToken = new OperatorToken(symbol, this.operators.get(symbol));
            } else if (c == '(') {
                ++openBraces;
                ParenthesesToken parenthesesToken = new ParenthesesToken(String.valueOf(c));
            } else if (c == '{') {
                ++openCurly;
                ParenthesesToken parenthesesToken = new ParenthesesToken(String.valueOf(c));
            } else if (c == '[') {
                ++openSquare;
                ParenthesesToken parenthesesToken = new ParenthesesToken(String.valueOf(c));
            } else if (c == ')') {
                --openBraces;
                ParenthesesToken parenthesesToken = new ParenthesesToken(String.valueOf(c));
            } else if (c == '}') {
                --openCurly;
                ParenthesesToken parenthesesToken = new ParenthesesToken(String.valueOf(c));
            } else {
                if (c != ']') throw new UnparsableExpressionException(expression, c, i + 1);
                --openSquare;
                ParenthesesToken parenthesesToken = new ParenthesesToken(String.valueOf(c));
            }
            tokens.add((Token)var7_21);
        }
        if (openCurly == 0 && !(openBraces != 0 | openSquare != 0)) return tokens;
        StringBuilder errorBuilder = new StringBuilder();
        errorBuilder.append("There are ");
        boolean first = true;
        if (openBraces != 0) {
            errorBuilder.append(Math.abs(openBraces) + " unmatched parantheses ");
            first = false;
        }
        if (openCurly != 0) {
            if (!first) {
                errorBuilder.append(" and ");
            }
            errorBuilder.append(Math.abs(openCurly) + " unmatched curly brackets ");
            first = false;
        }
        if (openSquare != 0) {
            if (!first) {
                errorBuilder.append(" and ");
            }
            errorBuilder.append(Math.abs(openSquare) + " unmatched square brackets ");
            first = false;
        }
        errorBuilder.append("in expression '" + expression + "'");
        throw new UnparsableExpressionException(errorBuilder.toString());
    }

    private boolean isOperatorStart(String op) {
        for (String operatorName : this.operators.keySet()) {
            if (!operatorName.startsWith(op)) continue;
            return true;
        }
        return false;
    }
}

