/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class PlaybackSettings {
    private static final String PREFIX = "playback.";
    private static final String PLAYBACK_FPS = "playbackFPS";
    private static final String PLAYBACK_LATENCY_CORRECTION = "playbackLatencyCorrection";
    private int playbackFPS;
    private float playbackLatencyCorrection;
    private static PlaybackSettings instance = null;

    private PlaybackSettings() {
    }

    public static PlaybackSettings getInstance() {
        if (instance == null) {
            instance = new PlaybackSettings();
            Preferences prefs = NbPreferences.forModule(PlaybackSettings.class);
            PlaybackSettings.instance.playbackFPS = prefs.getInt("playback.playbackFPS", 24);
            PlaybackSettings.instance.playbackLatencyCorrection = prefs.getFloat("playback.playbackLatencyCorrection", 0.0f);
        }
        return instance;
    }

    public void save() {
        Preferences prefs = NbPreferences.forModule(PlaybackSettings.class);
        prefs.putInt("playback.playbackFPS", this.playbackFPS);
        prefs.putFloat("playback.playbackLatencyCorrection", this.playbackLatencyCorrection);
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public int getPlaybackFPS() {
        return this.playbackFPS;
    }

    public void setPlaybackFPS(int playbackFPS) {
        this.playbackFPS = playbackFPS;
    }

    public float getPlaybackLatencyCorrection() {
        return this.playbackLatencyCorrection;
    }

    public void setPlaybackLatencyCorrection(float playbackLatencyCorrection) {
        this.playbackLatencyCorrection = playbackLatencyCorrection;
    }
}

