/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import blue.services.render.RealtimeRenderServiceFactory;
import blue.settings.GeneralSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class RealtimeRenderSettings {
    private static final String PREFIX = "realtimeRender.";
    private static final String ADVANCED_SETTINGS = "advancedSettings";
    private static final String AUDIO_DRIVER = "audioDriver";
    private static final String AUDIO_DRIVER_ENABLED = "audioDriverEnabled";
    private static final String AUDIO_IN_ENABLED = "audioInEnabled";
    private static final String AUDIO_IN_TEXT = "audioInText";
    private static final String AUDIO_OUT_ENABLED = "audioOutEnabled";
    private static final String AUDIO_OUT_TEXT = "audioOutText";
    private static final String BENCHMARK_ENABLED = "benchmarkEnabled";
    private static final String CSOUND_EXECUTABLE = "csoundExecutable";
    private static final String DEFAULT_KSMPS = "defaultKsmps";
    private static final String DEFAULT_NCHNLS = "defaultNchnls";
    private static final String DEFAULT_SR = "defaultSr";
    private static final String HARDWARE_BUFFER_ENABLED = "hardwareBufferEnabled";
    private static final String HARDWARE_BUFFER_SIZE = "hardwareBufferSize";
    private static final String MIDI_DRIVER = "midiDriver";
    private static final String MIDI_DRIVER_ENABLED = "midiDriverEnabled";
    private static final String MIDI_IN_ENABLED = "midiInEnabled";
    private static final String MIDI_IN_TEXT = "midiInText";
    private static final String MIDI_OUT_ENABLED = "midiOutEnabled";
    private static final String MIDI_OUT_TEXT = "midiOutText";
    private static final String NOTE_AMPS_ENABLED = "noteAmpsEnabled";
    private static final String OUT_OF_RANGE_ENABLED = "outOfRangeEnabled";
    private static final String SOFTWARE_BUFFER_ENABLED = "softwareBufferEnabled";
    private static final String SOFTWARE_BUFFER_SIZE = "softwareBufferSize";
    private static final String WARNINGS_ENABLED = "warningsEnabled";
    private static final String DISPLAYS_DISABLED = "displaysDisabled";
    private static final String USE_ZERO_DBFS = "useZeroDbFS";
    private static final String ZERO_DB_FS = "zeroDbFS";
    private static final String REALTIME_RENDER_SERVICE_FACTORY = "realtimeRenderServiceFactory";
    private static String[] AUDIO_DRIVERS = null;
    private static String[] MIDI_DRIVERS = null;
    public boolean audioDriverEnabled = true;
    public String audioDriver = "PortAudio";
    public boolean midiDriverEnabled = false;
    public String midiDriver = "PortMidi";
    public boolean audioOutEnabled = true;
    public boolean audioInEnabled = false;
    public boolean midiInEnabled = false;
    public boolean midiOutEnabled = false;
    public boolean softwareBufferEnabled = false;
    public boolean hardwareBufferEnabled = false;
    public boolean noteAmpsEnabled = true;
    public boolean outOfRangeEnabled = true;
    public boolean warningsEnabled = true;
    public boolean benchmarkEnabled = true;
    public String audioOutText = "dac";
    public String audioInText = "adc";
    public String midiInText = "";
    public String midiOutText = "";
    public String csoundExecutable = "csound";
    public String defaultSr = "44100";
    public String defaultKsmps = "1";
    public String defaultNchnls = "2";
    public int softwareBufferSize = 256;
    public int hardwareBufferSize = 1024;
    public boolean displaysDisabled = true;
    public String advancedSettings = "";
    public boolean useZeroDbFS = true;
    public String zeroDbFS = "1";
    public RealtimeRenderServiceFactory renderServiceFactory = null;
    private static RealtimeRenderSettings instance = null;

    private RealtimeRenderSettings() {
    }

    private static RealtimeRenderServiceFactory findRealtimeRenderServiceFactory(String renderServiceName) {
        RealtimeRenderServiceFactory[] services = RealtimeRenderSettings.getAvailableRealtimeRenderServices();
        RealtimeRenderServiceFactory foundService = null;
        if (renderServiceName == null || renderServiceName.isEmpty()) {
            foundService = services[0];
        } else {
            for (RealtimeRenderServiceFactory service : services) {
                if (!service.toString().equals(renderServiceName)) continue;
                foundService = service;
                break;
            }
            if (foundService == null) {
                foundService = services[0];
            }
        }
        return foundService;
    }

    public static RealtimeRenderSettings getInstance() {
        if (instance == null) {
            String osName = System.getProperty("os.name");
            int softwareBufferSize = 256;
            int hardwareBufferSize = 1024;
            String csoundExecutableDefault = "csound";
            String audioDriverDefault = "PortAudio";
            if (osName.contains("Windows")) {
                softwareBufferSize = 4096;
                hardwareBufferSize = 16384;
            } else if (osName.toLowerCase().contains("mac")) {
                softwareBufferSize = 1024;
                hardwareBufferSize = 4096;
                csoundExecutableDefault = "/usr/local/bin/csound";
                audioDriverDefault = "pa_bl";
            }
            instance = new RealtimeRenderSettings();
            Preferences prefs = NbPreferences.forModule(RealtimeRenderSettings.class);
            RealtimeRenderSettings.instance.csoundExecutable = prefs.get("realtimeRender.csoundExecutable", csoundExecutableDefault);
            RealtimeRenderSettings.instance.defaultSr = prefs.get("realtimeRender.defaultSr", "44100");
            RealtimeRenderSettings.instance.defaultKsmps = prefs.get("realtimeRender.defaultKsmps", "1");
            RealtimeRenderSettings.instance.defaultNchnls = prefs.get("realtimeRender.defaultNchnls", "2");
            RealtimeRenderSettings.instance.audioDriverEnabled = prefs.getBoolean("realtimeRender.audioDriverEnabled", true);
            RealtimeRenderSettings.instance.audioDriver = prefs.get("realtimeRender.audioDriver", audioDriverDefault);
            RealtimeRenderSettings.instance.audioOutEnabled = prefs.getBoolean("realtimeRender.audioOutEnabled", true);
            RealtimeRenderSettings.instance.audioOutText = prefs.get("realtimeRender.audioOutText", "dac");
            RealtimeRenderSettings.instance.audioInEnabled = prefs.getBoolean("realtimeRender.audioInEnabled", false);
            RealtimeRenderSettings.instance.audioInText = prefs.get("realtimeRender.audioInText", "adc");
            RealtimeRenderSettings.instance.midiDriverEnabled = prefs.getBoolean("realtimeRender.midiDriverEnabled", true);
            RealtimeRenderSettings.instance.midiDriver = prefs.get("realtimeRender.midiDriver", "PortMidi");
            RealtimeRenderSettings.instance.midiOutEnabled = prefs.getBoolean("realtimeRender.midiOutEnabled", false);
            RealtimeRenderSettings.instance.midiOutText = prefs.get("realtimeRender.midiOutText", "");
            RealtimeRenderSettings.instance.midiInEnabled = prefs.getBoolean("realtimeRender.midiInEnabled", false);
            RealtimeRenderSettings.instance.midiInText = prefs.get("realtimeRender.midiInText", "");
            RealtimeRenderSettings.instance.hardwareBufferEnabled = prefs.getBoolean("realtimeRender.hardwareBufferEnabled", false);
            RealtimeRenderSettings.instance.hardwareBufferSize = prefs.getInt("realtimeRender.hardwareBufferSize", hardwareBufferSize);
            RealtimeRenderSettings.instance.softwareBufferEnabled = prefs.getBoolean("realtimeRender.softwareBufferEnabled", false);
            RealtimeRenderSettings.instance.softwareBufferSize = prefs.getInt("realtimeRender.softwareBufferSize", softwareBufferSize);
            RealtimeRenderSettings.instance.noteAmpsEnabled = prefs.getBoolean("realtimeRender.noteAmpsEnabled", true);
            RealtimeRenderSettings.instance.outOfRangeEnabled = prefs.getBoolean("realtimeRender.outOfRangeEnabled", true);
            RealtimeRenderSettings.instance.warningsEnabled = prefs.getBoolean("realtimeRender.warningsEnabled", true);
            RealtimeRenderSettings.instance.benchmarkEnabled = prefs.getBoolean("realtimeRender.benchmarkEnabled", true);
            RealtimeRenderSettings.instance.displaysDisabled = prefs.getBoolean("realtimeRender.displaysDisabled", true);
            RealtimeRenderSettings.instance.advancedSettings = prefs.get("realtimeRender.advancedSettings", "");
            RealtimeRenderSettings.instance.useZeroDbFS = prefs.getBoolean("realtimeRender.useZeroDbFS", true);
            RealtimeRenderSettings.instance.zeroDbFS = prefs.get("realtimeRender.zeroDbFS", "1");
            String factoryName = prefs.get("realtimeRender.realtimeRenderServiceFactory", null);
            RealtimeRenderSettings.instance.renderServiceFactory = RealtimeRenderSettings.findRealtimeRenderServiceFactory(factoryName);
        }
        return instance;
    }

    public void save() {
        Preferences prefs = NbPreferences.forModule(RealtimeRenderSettings.class);
        prefs.put("realtimeRender.csoundExecutable", this.csoundExecutable);
        prefs.put("realtimeRender.defaultSr", this.defaultSr);
        prefs.put("realtimeRender.defaultKsmps", this.defaultKsmps);
        prefs.put("realtimeRender.defaultNchnls", this.defaultNchnls);
        prefs.putBoolean("realtimeRender.audioDriverEnabled", this.audioDriverEnabled);
        prefs.put("realtimeRender.audioDriver", this.audioDriver);
        prefs.putBoolean("realtimeRender.audioOutEnabled", this.audioOutEnabled);
        prefs.put("realtimeRender.audioOutText", this.audioOutText);
        prefs.putBoolean("realtimeRender.audioInEnabled", this.audioInEnabled);
        prefs.put("realtimeRender.audioInText", this.audioInText);
        prefs.putBoolean("realtimeRender.midiDriverEnabled", this.midiDriverEnabled);
        prefs.put("realtimeRender.midiDriver", this.midiDriver);
        prefs.putBoolean("realtimeRender.midiOutEnabled", this.midiOutEnabled);
        prefs.put("realtimeRender.midiOutText", this.midiOutText.toString());
        prefs.putBoolean("realtimeRender.midiInEnabled", this.midiInEnabled);
        prefs.put("realtimeRender.midiInText", this.midiInText);
        prefs.putBoolean("realtimeRender.hardwareBufferEnabled", this.hardwareBufferEnabled);
        prefs.putInt("realtimeRender.hardwareBufferSize", this.hardwareBufferSize);
        prefs.putBoolean("realtimeRender.softwareBufferEnabled", this.softwareBufferEnabled);
        prefs.putInt("realtimeRender.softwareBufferSize", this.softwareBufferSize);
        prefs.putBoolean("realtimeRender.noteAmpsEnabled", this.noteAmpsEnabled);
        prefs.putBoolean("realtimeRender.warningsEnabled", this.warningsEnabled);
        prefs.putBoolean("realtimeRender.outOfRangeEnabled", this.outOfRangeEnabled);
        prefs.putBoolean("realtimeRender.benchmarkEnabled", this.benchmarkEnabled);
        prefs.putBoolean("realtimeRender.displaysDisabled", this.displaysDisabled);
        prefs.put("realtimeRender.advancedSettings", this.advancedSettings);
        prefs.putBoolean("realtimeRender.useZeroDbFS", this.useZeroDbFS);
        prefs.put("realtimeRender.zeroDbFS", this.zeroDbFS);
        prefs.put("realtimeRender.realtimeRenderServiceFactory", this.renderServiceFactory.toString());
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getCommandLine(boolean useAudioOut, boolean useAudioIn, boolean useMidiIn, boolean useMidiOut) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.csoundExecutable).append(" ");
        if (!GeneralSettings.getInstance().isMessageColorsEnabled()) {
            buffer.append("-+msg_color=false ");
        }
        if (this.audioDriverEnabled) {
            buffer.append("-+rtaudio=").append(this.audioDriver).append(" ");
        }
        if (useAudioOut) {
            buffer.append("-o ").append(this.audioOutText).append(" ");
        }
        if (useAudioIn) {
            buffer.append("-i ").append(this.audioInText).append(" ");
        }
        if ((useMidiIn || useMidiOut) && this.midiDriverEnabled) {
            buffer.append("-+rtmidi=").append(this.midiDriver).append(" ");
        }
        if (useMidiIn) {
            buffer.append("-M ").append(this.midiInText).append(" ");
        }
        if (useMidiOut) {
            buffer.append("-Q ").append(this.midiOutText).append(" ");
        }
        if (this.softwareBufferEnabled) {
            buffer.append("-b").append(this.softwareBufferSize).append(" ");
        }
        if (this.hardwareBufferEnabled) {
            buffer.append("-B").append(this.hardwareBufferSize).append(" ");
        }
        if (this.displaysDisabled) {
            buffer.append("-d ");
        }
        return buffer.toString();
    }

    public static String[] getMIDIDrivers() {
        if (MIDI_DRIVERS == null) {
            String osName = System.getProperty("os.name").toLowerCase();
            MIDI_DRIVERS = osName.contains("windows") ? new String[]{"PortMIDI", "MME", "null"} : (osName.contains("mac") ? new String[]{"PortMIDI", "null"} : (osName.contains("linux") ? new String[]{"PortMIDI", "alsaseq", "ALSA", "null"} : new String[]{"PortMIDI", "MME", "ALSA", "null"}));
        }
        return MIDI_DRIVERS;
    }

    public static String[] getAudioDrivers() {
        if (AUDIO_DRIVERS == null) {
            String osName = System.getProperty("os.name").toLowerCase();
            AUDIO_DRIVERS = osName.contains("windows") ? new String[]{"PortAudio", "pa_cb", "pa_bl", "MME", "null"} : (osName.contains("mac") ? new String[]{"PortAudio", "pa_cb", "pa_bl", "CoreAudio", "JACK", "null"} : (osName.contains("linux") ? new String[]{"PortAudio", "pa_cb", "pa_bl", "ALSA", "JACK", "pulse", "null"} : new String[]{"PortAudio", "pa_cb", "pa_bl", "MME", "ALSA", "JACK", "pulse", "CoreAudio", "null"}));
        }
        return AUDIO_DRIVERS;
    }

    public static RealtimeRenderServiceFactory[] getAvailableRealtimeRenderServices() {
        Collection services = Lookup.getDefault().lookupAll(RealtimeRenderServiceFactory.class);
        ArrayList<RealtimeRenderServiceFactory> results = new ArrayList<RealtimeRenderServiceFactory>();
        for (RealtimeRenderServiceFactory factory : services) {
            if (!factory.isAvailable()) continue;
            results.add(factory);
        }
        return results.toArray(new RealtimeRenderServiceFactory[0]);
    }
}

