/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.net;

import de.sciss.net.OSCBundle;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCPacketCodec;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public abstract class OSCPacket {
    private static final byte[] hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    protected OSCPacket() {
    }

    public final int getSize() throws IOException {
        return this.getSize(OSCPacketCodec.getDefaultCodec());
    }

    public final int getSize(OSCPacketCodec c) throws IOException {
        return c.getSize(this);
    }

    public final void encode(ByteBuffer b) throws IOException {
        this.encode(OSCPacketCodec.getDefaultCodec(), b);
    }

    public final void encode(OSCPacketCodec c, ByteBuffer b) throws IOException {
        c.encode(this, b);
    }

    public static OSCPacket decode(ByteBuffer b) throws IOException {
        return OSCPacketCodec.getDefaultCodec().decode(b);
    }

    public static void printTextOn(PrintStream stream, OSCPacket p) {
        OSCPacket.printTextOn(stream, p, 0);
    }

    public static void printHexOn(PrintStream stream, ByteBuffer b) {
        int i;
        int lim = b.limit();
        byte[] txt = new byte[74];
        for (i = 4; i < 56; ++i) {
            txt[i] = 32;
        }
        txt[56] = 124;
        stream.println();
        i = b.position();
        while (i < lim) {
            int j = 0;
            txt[j++] = hex[i >> 12 & 0xF];
            txt[j++] = hex[i >> 8 & 0xF];
            txt[j++] = hex[i >> 4 & 0xF];
            txt[j++] = hex[i & 0xF];
            int m = 57;
            for (int k = 0; k < 16 && i < lim; ++k, ++i) {
                if ((k & 7) == 0) {
                    j += 2;
                }
                byte n = b.get();
                int n2 = ++j;
                txt[n2] = hex[n >> 4 & 0xF];
                int n3 = ++j;
                ++j;
                txt[n3] = hex[n & 0xF];
                txt[m++] = n > 31 && n < 127 ? (int)n : 46;
            }
            txt[m++] = 124;
            while (j < 54) {
                txt[j++] = 32;
            }
            while (m < 74) {
                txt[m++] = 32;
            }
            stream.write(txt, 0, 74);
            stream.println();
        }
        stream.println();
    }

    private static void printTextOn(PrintStream stream, OSCPacket p, int nestCount) {
        if (p instanceof OSCMessage) {
            int i;
            OSCMessage msg = (OSCMessage)p;
            for (i = 0; i < nestCount; ++i) {
                stream.print("  ");
            }
            stream.print("[ \"" + msg.getName() + "\"");
            for (i = 0; i < msg.getArgCount(); ++i) {
                Object o = msg.getArg(i);
                if (o instanceof Number) {
                    if (o instanceof Float || o instanceof Double) {
                        stream.print(", " + ((Number)o).floatValue());
                        continue;
                    }
                    stream.print(", " + ((Number)o).longValue());
                    continue;
                }
                if (o instanceof OSCPacket) {
                    stream.println(",");
                    OSCPacket.printTextOn(stream, (OSCPacket)o, nestCount + 1);
                    continue;
                }
                if (o instanceof byte[]) {
                    stream.print(", DATA[" + ((byte[])o).length + "]");
                    continue;
                }
                stream.print(", \"" + o.toString() + "\"");
            }
            stream.print(" ]");
        } else {
            int i;
            OSCBundle bndl = (OSCBundle)p;
            for (i = 0; i < nestCount; ++i) {
                stream.print("  ");
            }
            stream.print("[ \"#bundle\"");
            for (i = 0; i < bndl.getPacketCount(); ++i) {
                stream.println(",");
                OSCPacket.printTextOn(stream, bndl.getPacket(i), nestCount + 1);
            }
            for (i = 0; i < nestCount; ++i) {
                stream.print("  ");
            }
            stream.print("]");
        }
        if (nestCount == 0) {
            stream.println();
        }
    }
}

