/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.editor.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.python.editor.lexer.PythonCommentTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class PythonCommentLexer
implements Lexer<PythonCommentTokenId> {
    private static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<PythonCommentTokenId> tokenFactory;
    private final boolean substituting;
    private State state;

    public PythonCommentLexer(LexerRestartInfo<PythonCommentTokenId> info, boolean substituting) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        this.substituting = substituting;
        this.state = (State)((Object)info.state());
        if (this.state == null) {
            this.state = State.INIT;
        }
    }

    public Object state() {
        return this.state;
    }

    public Token<PythonCommentTokenId> nextToken() {
        switch (this.state) {
            case SEEN_NAME: 
            case SEEN_TYPE_KEY: {
                int ch;
                while ((ch = this.input.read()) == 58 && this.state == State.SEEN_NAME && this.input.readLength() == 1 || ch != -1 && Character.isWhitespace(ch)) {
                }
                if (ch != -1) {
                    this.input.backup(1);
                }
                if (this.input.readLength() > 0) {
                    this.state = this.state == State.SEEN_TYPE_KEY ? State.SEEN_TYPE_WS : State.SEEN_NAME_WS;
                    return this.tokenFactory.createToken((TokenId)PythonCommentTokenId.SEPARATOR, this.input.readLength());
                }
                return null;
            }
            case SEEN_NAME_WS: 
            case SEEN_TYPE_WS: {
                int ch;
                while ((ch = this.input.read()) != -1 && !Character.isWhitespace(ch) && ch != 58) {
                }
                if (ch != -1) {
                    this.input.backup(1);
                }
                if (this.input.readLength() > 0) {
                    PythonCommentTokenId id;
                    State nextState;
                    if (this.state == State.SEEN_TYPE_WS) {
                        nextState = State.SEEN_NAME;
                        id = PythonCommentTokenId.VARNAME;
                    } else {
                        nextState = State.INIT;
                        id = PythonCommentTokenId.TYPE;
                    }
                    this.state = nextState;
                    return this.tokenFactory.createToken((TokenId)id, this.input.readLength());
                }
                if (ch == -1) {
                    return null;
                }
                this.state = State.INIT;
                return this.nextToken();
            }
        }
        int last = -1;
        while (true) {
            int ch = this.input.read();
            switch (ch) {
                case -1: {
                    if (this.input.readLength() > 0) {
                        return this.tokenFactory.createToken((TokenId)PythonCommentTokenId.TEXT, this.input.readLength());
                    }
                    return null;
                }
                case 64: {
                    int initialReadLength = this.input.readLength();
                    if (this.input.read() == 116 && this.input.read() == 121 && this.input.read() == 112 && this.input.read() == 101) {
                        if (this.input.readLength() > 5) {
                            this.input.backup(5);
                            return this.tokenFactory.createToken((TokenId)PythonCommentTokenId.TEXT, this.input.readLength());
                        }
                        this.state = State.SEEN_TYPE_KEY;
                        return this.tokenFactory.createToken((TokenId)PythonCommentTokenId.TYPEKEY, this.input.readLength());
                    }
                    if (this.input.readLength() > initialReadLength) {
                        this.input.backup(this.input.readLength() - initialReadLength);
                        break;
                    }
                    return this.tokenFactory.createToken((TokenId)PythonCommentTokenId.TEXT, this.input.readLength());
                }
                case 84: {
                    if (last != -1 && Character.isLetter(last)) break;
                    int initialReadLength = this.input.readLength();
                    if (this.input.read() == 79 && this.input.read() == 68 && this.input.read() == 79) {
                        int peek = this.input.read();
                        this.input.backup(1);
                        if (peek == -1 || !Character.isLetter(peek)) {
                            if (this.input.readLength() > 4) {
                                this.input.backup(4);
                                return this.tokenFactory.createToken((TokenId)PythonCommentTokenId.TEXT, this.input.readLength());
                            }
                            return this.tokenFactory.createToken((TokenId)PythonCommentTokenId.TODO, this.input.readLength());
                        }
                    }
                    if (this.input.readLength() > initialReadLength) {
                        this.input.backup(this.input.readLength() - initialReadLength);
                        break;
                    }
                    return this.tokenFactory.createToken((TokenId)PythonCommentTokenId.TEXT, this.input.readLength());
                }
            }
            last = ch;
        }
    }

    public void release() {
    }

    private static enum State {
        INIT,
        SEEN_TYPE_KEY,
        SEEN_TYPE_WS,
        SEEN_NAME,
        SEEN_NAME_WS;

    }
}

