/*
 * Decompiled with CFR 0.152.
 */
package blue.midi;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BlueMidiDevice {
    private MidiDevice.Info info = null;
    private MidiDevice input = null;
    private ChangeListener cl = null;
    private ChangeEvent e;
    private boolean enabled = false;

    public BlueMidiDevice(MidiDevice.Info info) {
        this.info = info;
        this.e = new ChangeEvent(this);
    }

    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    protected void setMidiDevice(MidiDevice input) {
        this.input = input;
    }

    protected MidiDevice getMidiDevice() {
        return this.input;
    }

    public void open() throws MidiUnavailableException {
        if (this.input != null && this.input.isOpen()) {
            return;
        }
        try {
            this.input = MidiSystem.getMidiDevice(this.info);
            this.input.open();
            this.cl.stateChanged(this.e);
        }
        catch (MidiUnavailableException ex) {
            this.input = null;
            throw ex;
        }
        catch (IllegalArgumentException ex) {
            this.input = null;
        }
    }

    public boolean isOpen() {
        return this.input != null && this.input.isOpen();
    }

    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        this.input = null;
        if (this.cl != null) {
            this.cl.stateChanged(this.e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        if (this.info != null) {
            return this.info.getName();
        }
        return "Error";
    }

    public void setChangeListener(ChangeListener cl) {
        this.cl = cl;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BlueMidiDevice) {
            BlueMidiDevice dev2 = (BlueMidiDevice)obj;
            MidiDevice.Info info2 = dev2.info;
            return this.info.getDescription().equals(info2.getDescription()) && this.info.getName().equals(info2.getName()) && this.info.getVendor().equals(info2.getVendor()) && this.info.getVersion().equals(info2.getVersion());
        }
        return false;
    }

    public String getSaveName() {
        return this.info.getDescription() + this.info.getName() + this.info.getVendor() + this.info.getVersion();
    }
}

