/*
 * Decompiled with CFR 0.152.
 */
package blue.midi;

import blue.midi.BlueMidiDevice;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class MidiInputManager
implements Receiver,
ChangeListener {
    private static MidiInputManager instance = null;
    private Vector<Receiver> receivers = null;
    private ChangeEvent changeEvent = null;
    private Vector<BlueMidiDevice> items = new Vector();
    private boolean running = false;

    private MidiInputManager() {
        this.rescan();
    }

    public static synchronized MidiInputManager getInstance() {
        if (instance == null) {
            instance = new MidiInputManager();
        }
        return instance;
    }

    public void rescan() {
        MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
        Vector<BlueMidiDevice> newItems = new Vector<BlueMidiDevice>();
        for (int i = 0; i < info.length; ++i) {
            try {
                if (MidiSystem.getMidiDevice(info[i]).getMaxTransmitters() == 0) continue;
                BlueMidiDevice blueMidiDevice = new BlueMidiDevice(info[i]);
                BlueMidiDevice old = this.getDeviceByInfo(blueMidiDevice);
                if (old == null) {
                    blueMidiDevice.setChangeListener(this);
                    newItems.add(blueMidiDevice);
                    continue;
                }
                newItems.add(old);
                continue;
            }
            catch (MidiUnavailableException ex) {
                ex.printStackTrace();
            }
        }
        this.items = newItems;
        this.load();
    }

    private BlueMidiDevice getDeviceByInfo(BlueMidiDevice info) {
        for (BlueMidiDevice device : this.items) {
            if (!device.equals(info)) continue;
            return device;
        }
        return null;
    }

    public Vector<BlueMidiDevice> getInputDeviceOptions() {
        return this.items;
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        for (BlueMidiDevice device : this.items) {
            if (device.isEnabled()) {
                try {
                    device.open();
                }
                catch (MidiUnavailableException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                continue;
            }
            device.close();
        }
        this.running = true;
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        for (BlueMidiDevice device : this.items) {
            device.close();
        }
        this.running = false;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public void addReceiver(Receiver receiver) {
        if (this.receivers == null) {
            this.receivers = new Vector();
        }
        this.receivers.add(receiver);
    }

    public void removeReceiver(Receiver receiver) {
        if (this.receivers != null) {
            this.receivers.remove(receiver);
        }
    }

    private void broadcastMessage(MidiMessage message, long timeStamp) {
        if (this.receivers != null) {
            for (Receiver receiver : new Vector<Receiver>(this.receivers)) {
                receiver.send(message, timeStamp);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        BlueMidiDevice device = (BlueMidiDevice)e.getSource();
        if (device.isOpen()) {
            try {
                device.getMidiDevice().getTransmitter().setReceiver(this);
            }
            catch (MidiUnavailableException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        this.broadcastMessage(message, timeStamp);
    }

    @Override
    public void close() {
    }

    protected void save() {
        Preferences prefs = NbPreferences.forModule(MidiInputManager.class);
        for (BlueMidiDevice device : this.items) {
            prefs.putBoolean(device.getSaveName(), device.isEnabled());
        }
        try {
            prefs.sync();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void load() {
        Preferences prefs = NbPreferences.forModule(MidiInputManager.class);
        for (BlueMidiDevice device : this.items) {
            device.setEnabled(prefs.getBoolean(device.getSaveName(), false));
            if (!this.running) continue;
            if (device.isEnabled()) {
                try {
                    device.open();
                }
                catch (MidiUnavailableException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                continue;
            }
            device.close();
        }
    }
}

