/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.ui;

import blue.event.SelectionEvent;
import blue.event.SelectionListener;
import blue.mixer.Channel;
import blue.mixer.Mixer;
import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.score.layers.audio.core.AudioLayer;
import blue.score.layers.audio.core.AudioLayerGroup;
import blue.score.layers.audio.ui.AudioHeaderLayerPanel;
import blue.score.layers.audio.ui.AudioHeaderListLayout;
import blue.ui.utilities.SelectionModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import skt.swing.SwingUtil;

public class AudioHeaderListPanel
extends JPanel
implements LayerGroupListener,
SelectionListener {
    private final AudioLayerGroup layerGroup;
    private SelectionModel selection = new SelectionModel();
    JPopupMenu menu;
    AudioHeaderListLayout layout = new AudioHeaderListLayout();
    private final Mixer mixer;

    public AudioHeaderListPanel(AudioLayerGroup audioLayerGroup, Mixer mixer) {
        this.layerGroup = audioLayerGroup;
        this.mixer = mixer;
        this.setLayout(this.layout);
        this.layout.setAudioLayerGroup(audioLayerGroup);
        for (AudioLayer layer : this.layerGroup) {
            Channel c = mixer.findChannelById(layer.getUniqueId());
            this.add(new AudioHeaderLayerPanel(layer, c));
        }
        this.selection.addChangeListener(e -> this.updateSelection());
        LayerAddAction layerAddAction = new LayerAddAction();
        final LayerRemoveAction layerRemoveAction = new LayerRemoveAction();
        final PushUpAction pushUpAction = new PushUpAction();
        final PushDownAction pushDownAction = new PushDownAction();
        this.menu = new JPopupMenu("Layer Operations"){

            @Override
            public void show(Component invoker, int x, int y) {
                if (AudioHeaderListPanel.this.layerGroup == null) {
                    return;
                }
                layerRemoveAction.setEnabled(AudioHeaderListPanel.this.layerGroup.size() >= 2);
                pushUpAction.setEnabled(AudioHeaderListPanel.this.selection.getStartIndex() >= 1);
                pushDownAction.setEnabled(AudioHeaderListPanel.this.selection.getEndIndex() < AudioHeaderListPanel.this.layerGroup.size() - 1);
                super.show(invoker, x, y);
            }
        };
        this.menu.add(layerAddAction);
        this.menu.add(layerRemoveAction);
        this.menu.add(pushUpAction);
        this.menu.add(pushDownAction);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                AudioHeaderListPanel.this.requestFocus();
                if (me.isPopupTrigger()) {
                    Component c = AudioHeaderListPanel.this.getComponentAt(me.getPoint());
                    int index = AudioHeaderListPanel.this.getIndexOfComponent(c);
                    if (index > AudioHeaderListPanel.this.selection.getEndIndex() || index < AudioHeaderListPanel.this.selection.getStartIndex()) {
                        AudioHeaderListPanel.this.selection.setAnchor(index);
                    }
                    AudioHeaderListPanel.this.menu.show(me.getComponent(), me.getX(), me.getY());
                } else if (SwingUtilities.isLeftMouseButton(me)) {
                    Component c;
                    if (me.getClickCount() == 1) {
                        Component c2 = AudioHeaderListPanel.this.getComponentAt(me.getPoint());
                        int index = AudioHeaderListPanel.this.getIndexOfComponent(c2);
                        if (index < 0) {
                            return;
                        }
                        if (me.isShiftDown()) {
                            AudioHeaderListPanel.this.selection.setEnd(index);
                        } else {
                            AudioHeaderListPanel.this.selection.setAnchor(index);
                            ((AudioHeaderLayerPanel)c2).setSelected(true);
                        }
                    } else if (me.getClickCount() == 2 && (c = SwingUtilities.getDeepestComponentAt(AudioHeaderListPanel.this, me.getX(), me.getY())) != null && c instanceof JLabel) {
                        Component panel = AudioHeaderListPanel.this.getComponentAt(me.getPoint());
                        ((AudioHeaderLayerPanel)panel).editName();
                    }
                }
            }
        });
        this.selection.addChangeListener(e -> this.updateSelection());
        this.initActions();
    }

    private void initActions() {
        SwingUtil.installActions((JComponent)this, (Action[])new Action[]{new ShiftUpAction(), new UpAction(), new ShiftDownAction(), new DownAction()}, (int)1);
    }

    private int getIndexOfComponent(Component c) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != c) continue;
            return i;
        }
        return -1;
    }

    private void updateSelection() {
        int start = this.selection.getStartIndex();
        int end = this.selection.getEndIndex();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            AudioHeaderLayerPanel panel = (AudioHeaderLayerPanel)comps[i];
            panel.setSelected(i >= start && i <= end);
        }
    }

    public void checkSize() {
        if (this.layerGroup == null || this.getParent() == null) {
            this.setSize(0, 0);
            return;
        }
        int w = this.getParent().getWidth();
        int h = this.layerGroup.getTotalHeight();
        this.setSize(w, h);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkSize();
        if (this.layerGroup != null) {
            this.layerGroup.addLayerGroupListener((LayerGroupListener)this);
        }
    }

    @Override
    public void removeNotify() {
        if (this.layerGroup != null) {
            this.layerGroup.removeLayerGroupListener((LayerGroupListener)this);
        }
    }

    public void layerGroupChanged(LayerGroupDataEvent event) {
        switch (event.getType()) {
            case 0: {
                this.layersAdded(event);
                break;
            }
            case 1: {
                this.layersRemoved(event);
                break;
            }
            case 2: {
                this.contentsChanged(event);
            }
        }
    }

    public void layersAdded(LayerGroupDataEvent e) {
        int index = e.getStartIndex();
        AudioLayer sLayer = (AudioLayer)this.layerGroup.get(index);
        SwingUtilities.invokeLater(() -> {
            Channel c = this.mixer.findChannelById(sLayer.getUniqueId());
            AudioHeaderLayerPanel panel = new AudioHeaderLayerPanel(sLayer, c);
            this.add((Component)panel, index);
            this.checkSize();
        });
    }

    public void layersRemoved(LayerGroupDataEvent e) {
        int start = e.getStartIndex();
        int end = e.getEndIndex();
        SwingUtilities.invokeLater(() -> {
            for (int i = end; i >= start; --i) {
                this.remove(i);
            }
            this.checkSize();
            this.selection.setAnchor(-1);
        });
    }

    public void contentsChanged(LayerGroupDataEvent e) {
        int start = e.getStartIndex();
        int end = e.getEndIndex();
        boolean isUp = start >= 0 && end >= 0;
        SwingUtilities.invokeLater(() -> {
            if (isUp) {
                Component c = this.getComponent(start);
                AudioHeaderLayerPanel panel = (AudioHeaderLayerPanel)c;
                this.remove(start);
                this.add(c, end);
                int i1 = this.selection.getStartIndex() - 1;
                int i2 = this.selection.getEndIndex() - 1;
                this.selection.setAnchor(i1);
                this.selection.setEnd(i2);
            } else {
                Component c = this.getComponent(-start);
                AudioHeaderLayerPanel panel = (AudioHeaderLayerPanel)c;
                this.remove(-start);
                this.add(c, -end);
                int i1 = this.selection.getStartIndex() + 1;
                int i2 = this.selection.getEndIndex() + 1;
                this.selection.setAnchor(i1);
                this.selection.setEnd(i2);
            }
            this.revalidate();
        });
    }

    public void selectionPerformed(SelectionEvent e) {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.layout.preferredLayoutSize(this.getParent());
    }

    class LayerRemoveAction
    extends AbstractAction {
        public LayerRemoveAction() {
            super("Remove Layers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = AudioHeaderListPanel.this.selection.getStartIndex();
            int end = AudioHeaderListPanel.this.selection.getEndIndex();
            if (end < 0 || AudioHeaderListPanel.this.layerGroup.size() < 2) {
                return;
            }
            int len = end - start + 1;
            String message = "Please confirm deleting these " + len + " layers.";
            if (JOptionPane.showConfirmDialog(null, message) == 0) {
                AudioHeaderListPanel.this.layerGroup.removeLayers(start, end);
                AudioHeaderListPanel.this.selection.setAnchor(-1);
            }
        }
    }

    class LayerAddAction
    extends AbstractAction {
        public LayerAddAction() {
            super("Add Layer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int end = AudioHeaderListPanel.this.selection.getEndIndex();
            if (end < 0) {
                return;
            }
            AudioHeaderListPanel.this.layerGroup.newLayerAt(++end);
        }
    }

    class PushDownAction
    extends AbstractAction {
        public PushDownAction() {
            super("Push Down Layers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = AudioHeaderListPanel.this.selection.getStartIndex();
            int end = AudioHeaderListPanel.this.selection.getEndIndex();
            if (end < 0 || end >= AudioHeaderListPanel.this.layerGroup.size() - 1) {
                return;
            }
            AudioHeaderListPanel.this.layerGroup.pushDownLayers(start, end);
            AudioHeaderListPanel.this.selection.setAnchor(start + 1);
        }
    }

    class PushUpAction
    extends AbstractAction {
        public PushUpAction() {
            super("Push Up Layers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = AudioHeaderListPanel.this.selection.getStartIndex();
            int end = AudioHeaderListPanel.this.selection.getEndIndex();
            if (end < 0 || start == 0) {
                return;
            }
            AudioHeaderListPanel.this.layerGroup.pushUpLayers(start, end);
            AudioHeaderListPanel.this.selection.setAnchor(start - 1);
        }
    }

    class ShiftDownAction
    extends AbstractAction {
        public ShiftDownAction() {
            super("shift-Down");
            this.putValue("ShortDescription", "Shift-Down Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 64));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int length;
            int index = AudioHeaderListPanel.this.selection.getLastIndexSet() + 1;
            index = index >= (length = AudioHeaderListPanel.this.getComponents().length) ? length - 1 : index;
            AudioHeaderListPanel.this.selection.setEnd(index);
        }
    }

    class DownAction
    extends AbstractAction {
        public DownAction() {
            super("down");
            this.putValue("ShortDescription", "Down Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int length;
            int index = AudioHeaderListPanel.this.selection.getLastIndexSet() + 1;
            index = index >= (length = AudioHeaderListPanel.this.getComponents().length) ? length - 1 : index;
            AudioHeaderListPanel.this.selection.setAnchor(index);
        }
    }

    class ShiftUpAction
    extends AbstractAction {
        public ShiftUpAction() {
            super("shift-up");
            this.putValue("ShortDescription", "Shift-Up Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 64));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = AudioHeaderListPanel.this.selection.getLastIndexSet() - 1;
            index = index < 0 ? 0 : index;
            AudioHeaderListPanel.this.selection.setEnd(index);
        }
    }

    class UpAction
    extends AbstractAction {
        public UpAction() {
            super("up");
            this.putValue("ShortDescription", "Up Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = AudioHeaderListPanel.this.selection.getLastIndexSet() - 1;
            index = index < 0 ? 0 : index;
            AudioHeaderListPanel.this.selection.setAnchor(index);
        }
    }
}

