/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class TclInteger
implements InternalRep {
    private int value;

    private TclInteger(int i) {
        this.value = i;
    }

    private TclInteger(Interp interp, String str) throws TclException {
        this.value = Util.getInt((Interp)interp, (String)str);
    }

    public InternalRep duplicate() {
        return new TclInteger(this.value);
    }

    public void dispose() {
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static TclObject newInstance(int i) {
        return new TclObject(new TclInteger(i));
    }

    private static void setIntegerFromAny(Interp interp, TclObject tobj) throws TclException {
        InternalRep rep = tobj.getInternalRep();
        if (!(rep instanceof TclInteger)) {
            if (rep instanceof TclBoolean) {
                boolean b = TclBoolean.get(interp, tobj);
                if (b) {
                    tobj.setInternalRep(new TclInteger(1));
                } else {
                    tobj.setInternalRep(new TclInteger(0));
                }
            } else {
                tobj.setInternalRep(new TclInteger(interp, tobj.toString()));
            }
        }
    }

    public static int get(Interp interp, TclObject tobj) throws TclException {
        TclInteger.setIntegerFromAny(interp, tobj);
        TclInteger tint = (TclInteger)tobj.getInternalRep();
        return tint.value;
    }

    public static void set(TclObject tobj, int i) {
        tobj.invalidateStringRep();
        InternalRep rep = tobj.getInternalRep();
        if (rep instanceof TclInteger) {
            TclInteger tint = (TclInteger)rep;
            tint.value = i;
        } else {
            tobj.setInternalRep(new TclInteger(i));
        }
    }
}

