/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.CObject;
import tcl.lang.InternalRep;
import tcl.lang.TclList;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public final class TclObject {
    protected InternalRep internalRep;
    protected int refCount;
    protected String stringRep;

    public TclObject(InternalRep rep) {
        if (rep == null) {
            throw new TclRuntimeError("null InternalRep");
        }
        this.internalRep = rep;
        this.stringRep = null;
        this.refCount = 0;
    }

    protected TclObject(TclString rep, String s) {
        if (rep == null) {
            throw new TclRuntimeError("null InternalRep");
        }
        this.internalRep = rep;
        this.stringRep = s;
        this.refCount = 0;
    }

    public final InternalRep getInternalRep() {
        this.disposedCheck();
        return this.internalRep;
    }

    public final void setInternalRep(InternalRep rep) {
        this.disposedCheck();
        if (rep == null) {
            throw new TclRuntimeError("null InternalRep");
        }
        if (rep == this.internalRep) {
            return;
        }
        if (this.internalRep instanceof CObject && !(rep instanceof CObject)) {
            if (this.stringRep == null) {
                this.stringRep = this.internalRep.toString();
            }
            ((CObject)this.internalRep).makeReference(this);
        }
        this.internalRep.dispose();
        this.internalRep = rep;
    }

    public final String toString() {
        this.disposedCheck();
        if (this.stringRep == null) {
            this.stringRep = this.internalRep.toString();
        }
        return this.stringRep;
    }

    public final void invalidateStringRep() throws TclRuntimeError {
        this.disposedCheck();
        if (this.refCount > 1) {
            throw new TclRuntimeError("string representation of object \"" + this.toString() + "\" cannot be invalidated: refCount = " + this.refCount);
        }
        this.stringRep = null;
    }

    public final boolean isShared() {
        this.disposedCheck();
        return this.refCount > 1;
    }

    public final TclObject duplicate() {
        this.disposedCheck();
        if (this.internalRep instanceof TclString && this.stringRep == null) {
            this.stringRep = this.internalRep.toString();
        }
        TclObject newObj = new TclObject(this.internalRep.duplicate());
        newObj.stringRep = this.stringRep;
        newObj.refCount = 0;
        return newObj;
    }

    public final TclObject takeExclusive() throws TclRuntimeError {
        this.disposedCheck();
        if (this.refCount == 1) {
            return this;
        }
        if (this.refCount > 1) {
            if (this.internalRep instanceof TclString && this.stringRep == null) {
                this.stringRep = this.internalRep.toString();
            }
            TclObject newObj = new TclObject(this.internalRep.duplicate());
            newObj.stringRep = this.stringRep;
            newObj.refCount = 1;
            --this.refCount;
            return newObj;
        }
        throw new TclRuntimeError("takeExclusive() called on object \"" + this.toString() + "\" with: refCount = 0");
    }

    public final void preserve() throws TclRuntimeError {
        this.disposedCheck();
        if (this.internalRep instanceof CObject) {
            ((CObject)this.internalRep).incrRefCount();
        }
        this._preserve();
    }

    private final void _preserve() throws TclRuntimeError {
        ++this.refCount;
    }

    public final void release() {
        this.disposedCheck();
        if (this.internalRep instanceof CObject) {
            ((CObject)this.internalRep).decrRefCount();
        }
        this._release();
    }

    private final void _release() {
        --this.refCount;
        if (this.refCount <= 0) {
            this.internalRep.dispose();
            this.internalRep = null;
            this.stringRep = null;
        }
    }

    final int getRefCount() {
        return this.refCount;
    }

    final long getCObjectPtr() {
        if (this.internalRep instanceof CObject) {
            return ((CObject)this.internalRep).getCObjectPtr();
        }
        return 0L;
    }

    final int getCObjectInst() {
        if (this.internalRep instanceof CObject) {
            if (this.internalRep instanceof TclList) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private final void disposedCheck() {
        if (this.internalRep == null) {
            throw new TclRuntimeError("TclObject has been deallocated");
        }
    }
}

