/*
 * Decompiled with CFR 0.152.
 */
package blue.clojure.soundObject;

import blue.BlueSystem;
import blue.CompileData;
import blue.clojure.soundObject.ClojureObject;
import blue.gui.ExceptionDialog;
import blue.gui.InfoDialog;
import blue.score.ScoreObject;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObjectException;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;

public class ClojureObjectEditor
extends ScoreObjectEditor {
    ClojureObject clojureObj = null;
    UndoManager undo = new UndoRedo.Manager();
    MimeTypeEditorComponent codeEditor = new MimeTypeEditorComponent("text/x-clojure");
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JCheckBox processOnLoadCheckBox;
    private JButton testButton;

    public ClojureObjectEditor() {
        this.initComponents();
        this.initActions();
        this.add((Component)this.codeEditor, "Center");
        this.codeEditor.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (ClojureObjectEditor.this.clojureObj != null) {
                    ClojureObjectEditor.this.clojureObj.setClojureCode(ClojureObjectEditor.this.codeEditor.getText());
                }
            }
        });
        this.codeEditor.setUndoManager(this.undo);
        this.codeEditor.getDocument().addUndoableEditListener(this.undo);
        this.undo.setLimit(1000);
    }

    private void initActions() {
        InputMap inputMap = this.codeEditor.getJEditorPane().getInputMap();
        ActionMap actions = this.codeEditor.getJEditorPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(84, BlueSystem.getMenuShortcutKey()), "testSoundObject");
        actions.put("testSoundObject", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClojureObjectEditor.this.testSoundObject();
            }
        });
    }

    public final void editScoreObject(ScoreObject sObj) {
        this.clojureObj = null;
        if (sObj == null) {
            this.codeEditor.setText("null soundObject");
            this.codeEditor.getJEditorPane().setEnabled(false);
            this.processOnLoadCheckBox.setEnabled(false);
            return;
        }
        if (!(sObj instanceof ClojureObject)) {
            this.codeEditor.setText("[ERROR] not instance of ClojoureSOundObject");
            this.codeEditor.getJEditorPane().setEnabled(false);
            this.processOnLoadCheckBox.setEnabled(false);
            return;
        }
        ClojureObject tempPObj = (ClojureObject)sObj;
        this.codeEditor.setText(tempPObj.getClojureCode());
        this.codeEditor.getJEditorPane().setEnabled(true);
        this.codeEditor.getJEditorPane().setCaretPosition(0);
        this.processOnLoadCheckBox.setSelected(tempPObj.isOnLoadProcessable());
        this.processOnLoadCheckBox.setEnabled(true);
        this.undo.discardAllEdits();
        this.clojureObj = tempPObj;
    }

    public final void testSoundObject() {
        if (this.clojureObj == null) {
            return;
        }
        NoteList notes = null;
        try {
            notes = this.clojureObj.generateForCSD(CompileData.createEmptyCompileData(), 0.0, -1.0);
        }
        catch (SoundObjectException e) {
            ExceptionDialog.showExceptionDialog((Component)SwingUtilities.getRoot((Component)((Object)this)), (Throwable)e);
        }
        if (notes != null) {
            InfoDialog.showInformationDialog((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)notes.toString(), (String)BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.processOnLoadCheckBox = new JCheckBox();
        this.testButton = new JButton();
        this.setPreferredSize(new Dimension(596, 222));
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("(clojure-object)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.processOnLoadCheckBox.setText("Process On Load");
        this.processOnLoadCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClojureObjectEditor.this.processOnLoadCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.jPanel1.add((Component)this.processOnLoadCheckBox, gridBagConstraints);
        this.testButton.setText(BlueSystem.getString((String)"common.test"));
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClojureObjectEditor.this.testButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.testButton, gridBagConstraints);
        this.add(this.jPanel1, "North");
    }

    private void processOnLoadCheckBoxActionPerformed(ActionEvent evt) {
        if (this.clojureObj != null) {
            this.clojureObj.setOnLoadProcessable(this.processOnLoadCheckBox.isSelected());
        }
    }

    private void testButtonActionPerformed(ActionEvent evt) {
        this.testSoundObject();
    }
}

