/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import blue.soundObject.CeciliaModule;
import blue.soundObject.editor.ceciliaModule.Grapher;
import blue.soundObject.editor.ceciliaModule.GrapherLineController;
import blue.soundObject.editor.ceciliaModule.GrapherMenuBar;
import blue.soundObject.editor.ceciliaModule.SliderPanel;
import blue.soundObject.editor.ceciliaModule.TogglePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class GrapherEditPanel
extends JComponent {
    GrapherLineController grapherLineController = new GrapherLineController();
    Grapher grapher = new Grapher();
    GrapherMenuBar menu = new GrapherMenuBar();
    TogglePanel toggles = new TogglePanel();
    SliderPanel sliders = new SliderPanel();
    private static Pattern labelPattern = null;

    public GrapherEditPanel() {
        this.setLayout(new BorderLayout());
        JSplitPane mainJSP = new JSplitPane(1);
        JSplitPane graphJSP = new JSplitPane(0);
        JSplitPane sliderToggleJSP = new JSplitPane(1);
        mainJSP.add((Component)new JScrollPane(this.grapherLineController), "left");
        mainJSP.add((Component)graphJSP, "right");
        JPanel graphPane = new JPanel(new BorderLayout());
        graphPane.add((Component)this.menu, "North");
        graphPane.add(new JScrollPane(this.grapher));
        graphJSP.add((Component)graphPane, "top");
        graphJSP.add((Component)sliderToggleJSP, "bottom");
        sliderToggleJSP.add((Component)new JScrollPane(this.sliders), "left");
        sliderToggleJSP.add((Component)new JScrollPane(this.toggles), "right");
        this.add((Component)mainJSP, "Center");
        this.grapherLineController.setGrapher(this.grapher);
        this.menu.setGrapher(this.grapher);
        mainJSP.setDividerLocation(200);
        graphJSP.setDividerLocation(300);
        sliderToggleJSP.setDividerLocation(250);
    }

    public void editCeciliaModule(CeciliaModule ceciliaModule) {
        this.toggles.clearToggles();
        this.sliders.clearSliders();
        this.grapherLineController.clearPanel();
        this.grapher.clearPanel();
        this.createInterfaceForModule(ceciliaModule);
        this.toggles.editCeciliaModule(ceciliaModule);
        this.sliders.editCeciliaModule(ceciliaModule);
        this.grapherLineController.editCeciliaModule(ceciliaModule);
        this.grapher.editCeciliaModule(ceciliaModule);
    }

    private void createInterfaceForModule(CeciliaModule ceciliaModule) {
        String tk_interface = ceciliaModule.getModuleDefinition().tk_interface;
        StringTokenizer st = new StringTokenizer(tk_interface, "\n");
        while (st.hasMoreTokens()) {
            String objectType;
            StringTokenizer objectTokenizer;
            String line = st.nextToken().trim();
            if (line.length() == 0 || (objectTokenizer = new StringTokenizer(line)).countTokens() == 0 || !(objectType = objectTokenizer.nextToken()).equals("csepar") && objectTokenizer.countTokens() == 1) continue;
            if (objectType.equals("csepar")) {
                this.grapherLineController.addSeparator();
                continue;
            }
            String objectName = objectTokenizer.nextToken();
            switch (objectType) {
                case "cfilein": {
                    break;
                }
                case "cpopup": {
                    break;
                }
                case "ctoggle": {
                    this.toggles.addToggle(objectName);
                    break;
                }
                case "cslider": {
                    this.sliders.addSlider(objectName);
                    break;
                }
                case "cgraph": {
                    String label = this.findLabel(line);
                    if (label == null) {
                        label = objectName;
                    }
                    this.grapher.addGraphOrder(objectName);
                    this.grapherLineController.addGrapher(objectName, label);
                    break;
                }
            }
        }
    }

    private String findLabel(String line) {
        Matcher matcher = labelPattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    static {
        try {
            labelPattern = Pattern.compile("label\\s\"([^\"]*)");
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
        }
    }
}

