/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.BlueData;
import blue.BlueSystem;
import blue.Marker;
import blue.MarkersList;
import blue.event.PlayModeListener;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.services.render.RenderTimeManager;
import blue.services.render.RenderTimeManagerListener;
import blue.settings.PlaybackSettings;
import blue.ui.core.render.RealtimeRenderManager;
import blue.utility.NumberUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.openide.awt.StatusDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class MainToolBar
extends JToolBar
implements PlayModeListener,
PropertyChangeListener,
RenderTimeManagerListener {
    private static final String EMPTY_TIME = "--:--:--:--";
    private static MainToolBar instance = null;
    JButton previousMarkerButton;
    JButton nextMarkerButton;
    JButton rewindButton = new JButton();
    JButton playButton = new JButton();
    JButton stopButton = new JButton();
    JLabel toolStartLabel = new JLabel();
    JLabel toolEndLabel = new JLabel();
    JLabel playTimeLabel = new JLabel();
    JTextField playStartText = new JTextField();
    JTextField playEndText = new JTextField();
    JTextField playTimeText = new JTextField();
    BlueData data;
    JCheckBox loopBox = new JCheckBox();
    private boolean isUpdating = false;
    RenderTimeManager renderTimeManager = (RenderTimeManager)Lookup.getDefault().lookup(RenderTimeManager.class);

    public static MainToolBar getInstance() {
        if (instance == null) {
            instance = new MainToolBar();
        }
        return instance;
    }

    private MainToolBar() {
        this.setFloatable(false);
        RealtimeRenderManager.getInstance().addPlayModeListener(this);
        this.previousMarkerButton = new JButton(new PreviousMarkerAction());
        this.nextMarkerButton = new JButton(new NextMarkerAction());
        this.previousMarkerButton.setFocusable(false);
        this.nextMarkerButton.setFocusable(false);
        this.previousMarkerButton.setText("");
        this.nextMarkerButton.setText("");
        this.playStartText.setEditable(false);
        this.playEndText.setEditable(false);
        this.playTimeText.setEditable(false);
        this.playStartText.setFocusable(false);
        this.playEndText.setFocusable(false);
        this.playTimeText.setFocusable(false);
        this.rewindButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"blue/resources/images/Rewind16.gif")));
        this.rewindButton.addActionListener(e -> this.rewind());
        this.rewindButton.setFocusable(false);
        this.playButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"blue/resources/images/Play16.gif")));
        this.playButton.addActionListener(e -> this.renderProject());
        this.playButton.setFocusable(false);
        this.stopButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"blue/resources/images/Stop16.gif")));
        this.stopButton.addActionListener(e -> this.stopRendering());
        this.stopButton.setFocusable(false);
        this.toolStartLabel.setText(BlueSystem.getString((String)"playBar.startPlayFrom") + " ");
        this.toolStartLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.playStartText.setText("0.0");
        this.playStartText.setPreferredSize(new Dimension(80, 23));
        this.toolEndLabel.setText(BlueSystem.getString((String)"playBar.playTo") + " ");
        this.toolEndLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.playEndText.setText("");
        this.playEndText.setPreferredSize(new Dimension(80, 23));
        this.playTimeLabel.setText("Play Time: ");
        this.playTimeLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.playTimeText.setText(EMPTY_TIME);
        this.playTimeText.setPreferredSize(new Dimension(80, 23));
        this.loopBox.setFocusable(false);
        this.loopBox.setText("Loop");
        this.loopBox.addActionListener(e -> this.updateLoopRendering(this.loopBox.isSelected()));
        this.add((Component)this.toolStartLabel, null);
        this.add((Component)this.playStartText, null);
        this.add((Component)this.toolEndLabel, null);
        this.add((Component)this.playEndText, null);
        this.add(this.playTimeLabel);
        this.add(this.playTimeText);
        this.add((Component)this.loopBox, null);
        this.add(this.previousMarkerButton);
        this.add(this.nextMarkerButton);
        this.add((Component)this.rewindButton, null);
        this.add((Component)this.playButton, null);
        this.add((Component)this.stopButton, null);
        this.renderTimeManager.addPropertyChangeListener(evt -> {
            String prop = evt.getPropertyName();
            if (evt.getSource() == this.renderTimeManager && prop.equals("timePointer")) {
                double val = (Double)evt.getNewValue();
                if (val <= 0.0) {
                    this.playTimeText.setText(EMPTY_TIME);
                } else {
                    double latency = PlaybackSettings.getInstance().getPlaybackLatencyCorrection();
                    double newVal = val + this.renderTimeManager.getRenderStartTime() - latency;
                    this.playTimeText.setText(NumberUtilities.formatTime((double)newVal));
                }
            }
        });
        this.renderTimeManager.addRenderTimeManagerListener((RenderTimeManagerListener)this);
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.reinitialize();
    }

    private void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        BlueData data = null;
        if (project != null) {
            data = project.getData();
            this.setData(data);
        }
    }

    public void rewind() {
        if (this.data != null) {
            this.data.setRenderStartTime(0.0);
            this.data.setRenderEndTime(-1.0);
        }
    }

    protected void updateLoopRendering(boolean isLoopRendering) {
        if (!this.isUpdating && this.data != null) {
            this.data.setLoopRendering(isLoopRendering);
        }
    }

    public void renderProject() {
        RealtimeRenderManager.getInstance().renderProject(this.data);
    }

    public void stopRendering() {
        RealtimeRenderManager.getInstance().stopRendering();
    }

    public boolean isRendering() {
        return RealtimeRenderManager.getInstance().isRendering();
    }

    public void setData(BlueData data) {
        this.isUpdating = true;
        if (this.data != null) {
            this.data.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.data = data;
        data.addPropertyChangeListener((PropertyChangeListener)this);
        this.loopBox.setSelected(data.isLoopRendering());
        this.playStartText.setText(Double.toString(data.getRenderStartTime()));
        double endTime = data.getRenderEndTime();
        if (endTime < 0.0) {
            this.playEndText.setText("");
        } else {
            this.playEndText.setText(Double.toString(endTime));
        }
        this.isUpdating = false;
    }

    public void playModeChanged(int playMode) {
        SwingUtilities.invokeLater(() -> {
            if (playMode == 1) {
                this.playButton.setEnabled(false);
                StatusDisplayer.getDefault().setStatusText(BlueSystem.getString((String)"message.renderingCSD"));
            } else if (playMode == 0) {
                this.playButton.setEnabled(true);
                StatusDisplayer.getDefault().setStatusText(BlueSystem.getString((String)"message.finishedRenderingCSD"));
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.data) {
            String propertyName;
            switch (propertyName = evt.getPropertyName()) {
                case "renderStartTime": {
                    this.playStartText.setText(evt.getNewValue().toString());
                    break;
                }
                case "renderLoopTime": {
                    double doubleVal = Double.parseDouble(evt.getNewValue().toString());
                    if (doubleVal < 0.0) {
                        this.playEndText.setText("");
                        break;
                    }
                    this.playEndText.setText(evt.getNewValue().toString());
                    break;
                }
                case "loopRendering": {
                    this.isUpdating = true;
                    Boolean val = (Boolean)evt.getNewValue();
                    this.loopBox.setSelected(val);
                    this.isUpdating = false;
                }
            }
        }
    }

    public void renderInitiated() {
    }

    public void renderEnded() {
    }

    public void renderTimeUpdated(double timePointer) {
        double val = timePointer;
        if (val <= 0.0) {
            this.playTimeText.setText(EMPTY_TIME);
        } else {
            double latency = PlaybackSettings.getInstance().getPlaybackLatencyCorrection();
            double newVal = val + this.renderTimeManager.getRenderStartTime() - latency;
            this.playTimeText.setText(NumberUtilities.formatTime((double)newVal));
        }
    }

    class PreviousMarkerAction
    extends AbstractAction {
        public PreviousMarkerAction() {
            super("Go to Previous Marker");
            ImageIcon icon = new ImageIcon(ImageUtilities.loadImage((String)"blue/resources/images/StepBack16.gif"));
            this.putValue("ShortDescription", "Go to Previous Marker");
            this.putValue("SmallIcon", icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            double startTime = MainToolBar.this.data.getRenderStartTime();
            double newStartTime = 0.0;
            MarkersList markers = MainToolBar.this.data.getMarkersList();
            Marker selected = null;
            for (int i = markers.size() - 1; i >= 0; --i) {
                Marker a = markers.getMarker(i);
                if (!(a.getTime() < startTime)) continue;
                selected = a;
                break;
            }
            if (selected != null) {
                newStartTime = selected.getTime();
            }
            MainToolBar.this.data.setRenderStartTime(newStartTime);
        }
    }

    class NextMarkerAction
    extends AbstractAction {
        public NextMarkerAction() {
            super("Go to Next Marker");
            ImageIcon icon = new ImageIcon(ImageUtilities.loadImage((String)"blue/resources/images/StepForward16.gif"));
            this.putValue("ShortDescription", "Go to Next Marker");
            this.putValue("SmallIcon", icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            double startTime = MainToolBar.this.data.getRenderStartTime();
            MarkersList markers = MainToolBar.this.data.getMarkersList();
            Marker selected = null;
            for (int i = 0; i < markers.size(); ++i) {
                Marker a = markers.getMarker(i);
                if (!(a.getTime() > startTime)) continue;
                selected = a;
                break;
            }
            if (selected == null) {
                return;
            }
            double newStartTime = selected.getTime();
            MainToolBar.this.data.setRenderStartTime(newStartTime);
        }
    }
}

