/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.BlueSystem;
import blue.WindowSettingsSavable;
import blue.utility.XMLUtilities;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class WindowSettingManager {
    private static WindowSettingManager manager = null;
    private static final String SETTINGS_FILE_NAME = "windowSettings.xml";
    private HashMap<String, Window> windows = new HashMap();
    private HashMap<String, Element> settings = new HashMap();

    private WindowSettingManager() {
        this.load();
    }

    public static WindowSettingManager getInstance() {
        if (manager == null) {
            manager = new WindowSettingManager();
        }
        return manager;
    }

    private void load() {
        String userDir = BlueSystem.getUserConfigurationDirectory();
        String settingsFile = userDir + File.separator + SETTINGS_FILE_NAME;
        File f = new File(settingsFile);
        if (!f.exists()) {
            return;
        }
        try {
            Document doc = new Document(f);
            Element root = doc.getRoot();
            Elements nodes = root.getElements();
            while (nodes.hasMoreElements()) {
                Element node = nodes.next();
                String key = node.getAttributeValue("windowName");
                this.settings.put(key, node);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.updateSettings();
        Document doc = new Document();
        Element root = doc.setRoot("windowSettings");
        for (Element node : this.settings.values()) {
            root.addElement(node);
        }
        String userDir = BlueSystem.getUserConfigurationDirectory();
        String settingsFile = userDir + File.separator + SETTINGS_FILE_NAME;
        try (FileOutputStream out = new FileOutputStream(settingsFile);){
            doc.write((OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateSettings() {
        for (Map.Entry<String, Window> entry : this.windows.entrySet()) {
            Element node;
            String key = entry.getKey();
            Window w = entry.getValue();
            if (w instanceof WindowSettingsSavable) {
                WindowSettingsSavable savable = (WindowSettingsSavable)((Object)w);
                node = savable.saveWindowSettings();
            } else {
                node = WindowSettingManager.getBasicSettings(w);
            }
            node.setAttribute("windowName", key);
            this.settings.put(key, node);
        }
    }

    public void registerWindow(String windowName, Window window) {
        if (this.windows.containsKey(windowName)) {
            System.err.println("Window already registered with name: " + windowName);
        }
        if (!(window instanceof WindowSettingsSavable)) {
            System.err.println("Window with name " + windowName + " is not an instance of WindowsSettingSavable");
        }
        this.windows.put(windowName, window);
        if (this.settings.containsKey(windowName) && window instanceof WindowSettingsSavable) {
            WindowSettingsSavable savable = (WindowSettingsSavable)((Object)window);
            savable.loadWindowSettings(this.settings.get(windowName));
        }
    }

    public static Element getBasicSettings(Window window) {
        Element root = new Element("window");
        root.addElement(XMLUtilities.writeInt((String)"x", (int)window.getX()));
        root.addElement(XMLUtilities.writeInt((String)"y", (int)window.getY()));
        root.addElement(XMLUtilities.writeInt((String)"width", (int)window.getWidth()));
        root.addElement(XMLUtilities.writeInt((String)"height", (int)window.getHeight()));
        return root;
    }

    public static void setBasicSettings(Element data, Window window) {
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "x": {
                    int x = Integer.parseInt(node.getTextString());
                    window.setLocation(x, window.getY());
                    break;
                }
                case "y": {
                    int y = Integer.parseInt(node.getTextString());
                    window.setLocation(window.getX(), y);
                    break;
                }
                case "width": {
                    int w = Integer.parseInt(node.getTextString());
                    window.setSize(w, window.getHeight());
                    break;
                }
                case "height": {
                    int h = Integer.parseInt(node.getTextString());
                    window.setSize(window.getWidth(), h);
                }
            }
        }
    }
}

