/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.gui.LabelledItemPanel;
import blue.score.ScoreObject;
import blue.soundObject.FrozenSoundObject;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.ui.utilities.FileChooserManager;
import blue.utility.FileUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class FrozenSoundObjectEditor
extends ScoreObjectEditor {
    private FrozenSoundObject fso;
    private JLabel frozenObjectName = new JLabel();
    private JLabel frozenObjectType = new JLabel();
    private JLabel frozenWaveFileName = new JLabel();
    private JLabel frozenSoundObjectDuration = new JLabel();

    public FrozenSoundObjectEditor() {
        JButton button = new JButton("Save Copy");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.frozenWaveFileName);
        panel.add(button);
        button.addActionListener(e -> this.saveCopy());
        LabelledItemPanel itemPanel = new LabelledItemPanel();
        this.setLayout(new BorderLayout());
        itemPanel.addItem(BlueSystem.getString((String)"frozenSoundObject.name") + " ", this.frozenObjectName);
        itemPanel.addItem(BlueSystem.getString((String)"frozenSoundObject.type") + " ", this.frozenObjectType);
        itemPanel.addItem(BlueSystem.getString((String)"frozenSoundObject.waveName") + " ", panel);
        itemPanel.addItem(BlueSystem.getString((String)"frozenSoundObject.duration") + " ", this.frozenSoundObjectDuration);
        JScrollPane jsp = new JScrollPane(itemPanel);
        jsp.setBorder(null);
        this.add((Component)jsp, "Center");
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.setMultiSelectionEnabled((Object)this, false);
        fcm.setDialogTitle((Object)this, "Save Copy of Frozen Soundfile");
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null || !sObj.getClass().getName().equals("blue.soundObject.FrozenSoundObject")) {
            this.fso = null;
            return;
        }
        this.fso = (FrozenSoundObject)sObj;
        this.frozenObjectName.setText(this.fso.getFrozenSoundObject().getName());
        this.frozenObjectType.setText(this.fso.getFrozenSoundObject().getClass().getName());
        this.frozenWaveFileName.setText(this.fso.getFrozenWaveFileName());
        this.frozenSoundObjectDuration.setText(Double.toString(this.fso.getFrozenSoundObject().getSubjectiveDuration()));
    }

    protected void saveCopy() {
        File f = BlueSystem.findFile((String)this.fso.getFrozenWaveFileName());
        if (f == null) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)("Could not locate frozen file:\n\n" + this.fso.getFrozenWaveFileName()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return;
        }
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.setCurrentDirectory((Object)this, BlueSystem.getCurrentProjectDirectory());
        File retVal = fcm.showSaveDialog((Object)this, (Component)WindowManager.getDefault().getMainWindow());
        if (retVal != null) {
            File dest = retVal;
            if (dest.exists()) {
                if (dest.isDirectory()) {
                    NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)"Destination is a directory.", 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                    return;
                }
                if (dest.getName().startsWith("freeze")) {
                    NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)"Can not overwrite freeze files.", 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                    return;
                }
                NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)("Overwrite file " + dest.getName() + "?"), 2);
                Object conf = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (!NotifyDescriptor.OK_OPTION.equals(conf)) {
                    return;
                }
            }
            try {
                FileUtilities.copyFile((File)f, (File)dest);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

