/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pianoRoll;

import blue.BlueSystem;
import blue.soundObject.pianoRoll.Scale;
import blue.ui.utilities.FileChooserManager;
import blue.ui.utilities.UiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScaleSelectionPanel
extends JComponent {
    public static String FILE_CHOOSER_ID = "scaleSelectionPanel";
    JTextField fileNameField = new JTextField();
    Scale scale = null;
    Vector<ChangeListener> changeListeners = null;
    ChangeEvent c = null;
    JPopupMenu popup = new JPopupMenu();

    public ScaleSelectionPanel() {
        this.setLayout(new BorderLayout());
        this.initScaleFileSelector();
        JButton fileButton = new JButton("...");
        fileButton.addActionListener(e -> {
            List rValue = FileChooserManager.getDefault().showOpenDialog((Object)FILE_CHOOSER_ID, null);
            if (!rValue.isEmpty()) {
                File f = (File)rValue.get(0);
                if (!f.exists()) {
                    return;
                }
                this.scale = Scale.loadScale((File)f);
                this.updateDisplay();
                this.fireChangeEvent();
            }
        });
        this.fileNameField.setEditable(false);
        this.add((Component)this.fileNameField, "Center");
        this.add((Component)fileButton, "East");
        this.popup.add(new AbstractAction("Reset (12TET)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScaleSelectionPanel.this.setScale(Scale.get12TET());
                ScaleSelectionPanel.this.fireChangeEvent();
            }
        });
        this.fileNameField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (UiUtilities.isRightMouseButton((MouseEvent)evt)) {
                    Component c = evt.getComponent();
                    ScaleSelectionPanel.this.popup.show(c, evt.getX(), evt.getY());
                }
            }
        });
    }

    private void initScaleFileSelector() {
        FileChooserManager fcm = FileChooserManager.getDefault();
        if (fcm.isDialogDefined((Object)FILE_CHOOSER_ID)) {
            return;
        }
        fcm.setDialogTitle((Object)FILE_CHOOSER_ID, BlueSystem.getString((String)"pianoRoll.selectScalaFile"));
        fcm.addFilter((Object)FILE_CHOOSER_ID, new FileChooser.ExtensionFilter("Scala File (*.scl)", new String[]{"*.scl"}));
        String fileName = BlueSystem.getUserConfigurationDirectory();
        fileName = fileName + File.separator + "scl";
        File defaultDir = new File(fileName);
        if (defaultDir.exists() && defaultDir.isDirectory()) {
            fcm.setSelectedFile((Object)FILE_CHOOSER_ID, defaultDir);
        }
    }

    public void setScale(Scale scale) {
        this.scale = scale;
        this.updateDisplay();
    }

    public Scale getScale() {
        return this.scale;
    }

    private void updateDisplay() {
        if (this.scale == null) {
            this.fileNameField.setText("");
        } else {
            this.fileNameField.setText(this.scale.getScaleName());
        }
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.changeListeners == null) {
            this.changeListeners = new Vector();
        }
        this.changeListeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(cl);
        }
    }

    protected void fireChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.c == null) {
            this.c = new ChangeEvent(this);
        }
        for (ChangeListener cl : this.changeListeners) {
            cl.stateChanged(this.c);
        }
    }
}

