/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.sound;

import blue.ui.utilities.GraphLabels;
import java.text.DecimalFormat;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class TimeBar
extends Canvas {
    DoubleProperty startTime = new SimpleDoubleProperty(0.0);
    DoubleProperty duration = new SimpleDoubleProperty(1.0);
    Font f = Font.font((String)"System", (FontWeight)FontWeight.LIGHT, (double)10.0);
    Text t = new Text();
    DecimalFormat df = new DecimalFormat();

    public TimeBar() {
        this.repaint();
        this.boundsInParentProperty().addListener((obs, old, newVal) -> this.repaint());
        this.startTime.addListener((obs, old, newVal) -> this.repaint());
        this.duration.addListener((obs, old, newVal) -> this.repaint());
        this.getGraphicsContext2D().setFont(this.f);
        this.t.setFont(this.f);
    }

    public final void repaint() {
        GraphicsContext gc = this.getGraphicsContext2D();
        double w = this.getWidth();
        double h = this.getHeight();
        gc.setFill((Paint)Color.BLACK);
        gc.fillRect(0.0, 0.0, w, h);
        gc.setStroke((Paint)Color.WHITE);
        GraphLabels.drawTicks((double)this.getStartTime(), (double)(this.getStartTime() + this.getDuration()), (int)((int)(w / 100.0)), (num, nfrac) -> {
            this.df.setMaximumFractionDigits(nfrac);
            this.df.setMinimumFractionDigits(nfrac);
            String txt = this.df.format(num);
            this.t.setText(txt);
            double x = this.getWidth() * (num - this.getStartTime()) / this.getDuration();
            gc.strokeLine(x, 10.0, x, h);
            gc.strokeText(txt, 0.0 + x + 2.0, 16.0);
        });
    }

    public final void setStartTime(double value) {
        this.startTime.set(value);
    }

    public final double getStartTime() {
        return this.startTime.get();
    }

    public final DoubleProperty startTimeProperty() {
        return this.startTime;
    }

    public final void setDuration(double value) {
        this.duration.set(value);
    }

    public final double getDuration() {
        return this.duration.get();
    }

    public final DoubleProperty durationProperty() {
        return this.duration;
    }
}

