/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.codeRepository;

import blue.BlueSystem;
import blue.tools.codeRepository.CodeRepositoryTreeNode;
import blue.tools.codeRepository.ElementHolder;
import blue.ui.core.editor.actions.CodeRepositoryMenu;
import electric.xml.Child;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import electric.xml.XMLDecl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class CodeRepositoryManager {
    public static TreeNode getCodeRepositoryTreeNode(boolean getLeafNodes) throws ParseException {
        File repository = BlueSystem.getCodeRepository();
        Document doc = new Document(repository);
        Element root = doc.getRoot();
        CodeRepositoryTreeNode rootNode = CodeRepositoryManager.getTreeNode(root, getLeafNodes);
        return rootNode;
    }

    private static CodeRepositoryTreeNode getTreeNode(Element node, boolean getLeafNodes) {
        CodeRepositoryTreeNode returnNode = new CodeRepositoryTreeNode();
        ElementHolder tempElem = new ElementHolder();
        returnNode.setUserObject(tempElem);
        switch (node.getName()) {
            case "customAccelerators": {
                tempElem.title = BlueSystem.getString((String)"codeRepository.title");
                tempElem.isGroup = true;
                tempElem.isRoot = true;
                returnNode.setAllowsChildren(true);
                Elements children = node.getElements();
                while (children.hasMoreElements()) {
                    returnNode.add(CodeRepositoryManager.getTreeNode(children.next(), getLeafNodes));
                }
                break;
            }
            case "customGroup": {
                tempElem.title = node.getAttribute("name").getValue();
                tempElem.isGroup = true;
                returnNode.setAllowsChildren(true);
                if (!getLeafNodes) break;
                Elements children = node.getElements();
                while (children.hasMoreElements()) {
                    returnNode.add(CodeRepositoryManager.getTreeNode(children.next(), getLeafNodes));
                }
                break;
            }
            case "customAccelerator": {
                returnNode.setAllowsChildren(false);
                tempElem.title = node.getElement("name").getTextString();
                tempElem.text = node.getElement("signature").getTextString();
            }
        }
        return returnNode;
    }

    public static void saveCodeRepository(DefaultMutableTreeNode node) {
        Element root = CodeRepositoryManager.getElement(node);
        Document doc = new Document();
        doc.addChild((Child)new XMLDecl("1.0", "UTF-8"));
        doc.setRoot(root);
        try (FileOutputStream out = new FileOutputStream(BlueSystem.getCodeRepository());){
            doc.write((OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CodeRepositoryMenu.reinitialize();
    }

    private static Element getElement(DefaultMutableTreeNode node) {
        ElementHolder elemHolder = (ElementHolder)node.getUserObject();
        Element elem = new Element();
        if (elemHolder.isRoot) {
            elem.setName("customAccelerators");
            for (int i = 0; i < node.getChildCount(); ++i) {
                elem.addElement(CodeRepositoryManager.getElement((DefaultMutableTreeNode)node.getChildAt(i)));
            }
        } else if (elemHolder.isGroup) {
            elem.setName("customGroup");
            elem.setAttribute("name", elemHolder.title);
            for (int i = 0; i < node.getChildCount(); ++i) {
                elem.addElement(CodeRepositoryManager.getElement((DefaultMutableTreeNode)node.getChildAt(i)));
            }
        } else {
            elem.setName("customAccelerator");
            elem.addElement(new Element("name").setText(elemHolder.title));
            elem.addElement(new Element("signature").setText(elemHolder.text));
        }
        return elem;
    }
}

