/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.ui.core.mixer.ChannelListLayout;
import blue.ui.core.mixer.ChannelOutComboBoxModel;
import blue.ui.core.mixer.ChannelPanel;
import blue.util.ObservableListEvent;
import blue.util.ObservableListListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ChannelListPanel
extends JComponent
implements ObservableListListener<Channel>,
PropertyChangeListener {
    private ChannelList channels = null;
    private ChannelList subChannels = null;

    public ChannelListPanel() {
        this.setLayout(new ChannelListLayout());
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Dimension preferredLayoutSize = ChannelListPanel.this.getLayout().preferredLayoutSize(ChannelListPanel.this);
                ChannelListPanel.this.setPreferredSize(preferredLayoutSize);
                ChannelListPanel.this.setSize(preferredLayoutSize);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Dimension preferredLayoutSize = ChannelListPanel.this.getLayout().preferredLayoutSize(ChannelListPanel.this);
                ChannelListPanel.this.setPreferredSize(preferredLayoutSize);
                ChannelListPanel.this.setSize(preferredLayoutSize);
            }
        });
        this.setMinimumSize(new Dimension(0, 0));
    }

    public void setChannelList(ChannelList channels, ChannelList subChannels) {
        if (this.channels != null) {
            this.channels.removeListener((ObservableListListener)this);
        }
        this.channels = channels;
        this.subChannels = subChannels;
        this.rebuildChannelsUI(channels);
        this.channels.addListener((ObservableListListener)this);
    }

    public ChannelList getChannels() {
        return this.channels;
    }

    private void clearChannels() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ChannelPanel cPanel = (ChannelPanel)this.getComponent(i);
            cPanel.clear();
        }
        this.removeAll();
    }

    private void rebuildChannelsUI(ChannelList channels) {
        this.clearChannels();
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = (Channel)channels.get(i);
            ChannelPanel cPanel = this.createChannelPanel(channel);
            this.add(cPanel);
        }
        this.revalidate();
    }

    private ChannelPanel createChannelPanel(Channel channel) {
        ChannelPanel cPanel = new ChannelPanel();
        ChannelOutComboBoxModel model = new ChannelOutComboBoxModel();
        model.setChannels(this.subChannels);
        model.setSelectedItem(channel.getOutChannel());
        cPanel.setChannelOutModel(model);
        cPanel.setChannel(channel);
        return cPanel;
    }

    void sort() {
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            list.add(this.getComponent(i));
        }
        this.removeAll();
        Collections.sort(list);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.add((Component)it.next());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("name")) {
            String oldName = (String)pce.getOldValue();
            String newName = (String)pce.getNewValue();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                ChannelPanel chanPanel = (ChannelPanel)this.getComponent(i);
                ChannelOutComboBoxModel model = (ChannelOutComboBoxModel)chanPanel.getChannelOutModel();
                model.reconcile(oldName, newName);
            }
        }
    }

    @Override
    public void removeNotify() {
        if (this.channels != null) {
            this.channels.removeListener((ObservableListListener)this);
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.channels != null) {
            this.channels.addListener((ObservableListListener)this);
        }
    }

    public void listChanged(ObservableListEvent<Channel> listEvent) {
        switch (listEvent.getType()) {
            case 0: {
                this.intervalAdded(listEvent);
                break;
            }
            case 1: {
                this.intervalRemoved(listEvent);
                break;
            }
            case 2: {
                this.contentsChanged();
            }
        }
    }

    public void intervalAdded(ObservableListEvent<Channel> e) {
        int index0 = e.getStartIndex();
        int index1 = e.getEndIndex();
        SwingUtilities.invokeLater(() -> {
            for (int i = index0; i <= index1; ++i) {
                Channel channel = (Channel)this.channels.get(i);
                ChannelPanel cPanel = this.createChannelPanel(channel);
                this.add((Component)cPanel, i);
            }
            this.revalidate();
        });
    }

    public void intervalRemoved(ObservableListEvent<Channel> e) {
        int index0 = e.getStartIndex();
        int index1 = e.getEndIndex();
        SwingUtilities.invokeLater(() -> {
            for (int i = index1; i >= index0; --i) {
                ChannelPanel cPanel = (ChannelPanel)this.getComponent(i);
                cPanel.clear();
                this.remove(index0);
            }
            this.revalidate();
        });
    }

    public void contentsChanged() {
        SwingUtilities.invokeLater(() -> this.rebuildChannelsUI(this.channels));
    }
}

