/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.mixer.Effect;
import blue.utility.ListUtil;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;

public class EffectCategory {
    private String categoryName = "New Effect Category";
    private ArrayList<EffectCategory> subCategories = new ArrayList();
    private ArrayList<Effect> effects = new ArrayList();
    private boolean isRoot = false;

    public EffectCategory() {
    }

    public EffectCategory(EffectCategory ec) {
        this.categoryName = ec.categoryName;
        this.isRoot = ec.isRoot;
        for (EffectCategory ecat : ec.subCategories) {
            this.subCategories.add(new EffectCategory(ecat));
        }
        for (Effect effect : ec.effects) {
            this.effects.add(new Effect(effect));
        }
    }

    public String toString() {
        return this.getCategoryName();
    }

    public boolean removeEffect(Effect effect) {
        int index = ListUtil.indexOfByRef(this.effects, (Object)effect);
        if (index >= 0) {
            this.effects.remove(index);
            return true;
        }
        for (EffectCategory category : this.subCategories) {
            if (!category.removeEffect(effect)) continue;
            return true;
        }
        return false;
    }

    public boolean removeEffectCategory(EffectCategory category) {
        int index = ListUtil.indexOfByRef(this.subCategories, (Object)category);
        if (index >= 0) {
            this.subCategories.remove(index);
            return true;
        }
        for (EffectCategory tempCategory : this.subCategories) {
            if (!tempCategory.removeEffectCategory(category)) continue;
            return true;
        }
        return false;
    }

    public void addEffectCategory(EffectCategory category) {
        this.subCategories.add(category);
    }

    public void addEffect(int index, Effect effect) {
        this.effects.add(index, effect);
    }

    public void addEffect(Effect effect) {
        this.effects.add(effect);
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public ArrayList getEffects() {
        return this.effects;
    }

    public void setEffects(ArrayList instruments) {
        this.effects = instruments;
    }

    public ArrayList getSubCategories() {
        return this.subCategories;
    }

    public void setSubCategories(ArrayList subCategories) {
        this.subCategories = subCategories;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public static EffectCategory loadFromXML(Element data) throws Exception {
        EffectCategory instrCat = new EffectCategory();
        instrCat.setCategoryName(data.getAttributeValue("categoryName"));
        instrCat.setRoot(Boolean.valueOf(data.getAttributeValue("isRoot")));
        Elements subCatNodes = data.getElements("effectCategory");
        while (subCatNodes.hasMoreElements()) {
            instrCat.addEffectCategory(EffectCategory.loadFromXML(subCatNodes.next()));
        }
        Elements effects = data.getElements("effect");
        while (effects.hasMoreElements()) {
            instrCat.addEffect(Effect.loadFromXML((Element)effects.next()));
        }
        return instrCat;
    }

    public Element saveAsXML() {
        Element retVal = new Element("effectCategory");
        retVal.setAttribute("categoryName", this.getCategoryName());
        retVal.setAttribute("isRoot", Boolean.toString(this.isRoot()));
        for (EffectCategory tempCat : this.subCategories) {
            retVal.addElement(tempCat.saveAsXML());
        }
        for (Effect effect : this.effects) {
            retVal.addElement(effect.saveAsXML());
        }
        return retVal;
    }
}

