/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.jfx.BlueFX;
import blue.mixer.Effect;
import blue.orchestra.blueSynthBuilder.BSBObjectRegistry;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBEditPane;
import java.awt.Component;
import java.awt.Frame;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class EffectEditorManager {
    private static EffectEditorManager manager = null;
    private Map<Effect, WeakReference<JDialog>> map = new WeakHashMap<Effect, WeakReference<JDialog>>();

    private EffectEditorManager() {
    }

    public void clear() {
        for (WeakReference<JDialog> ref : this.map.values()) {
            JDialog dialog = (JDialog)ref.get();
            if (dialog == null) continue;
            dialog.setVisible(false);
            dialog.dispose();
        }
        this.map.clear();
    }

    public void removeEffect(Effect effect) {
        if (this.map.containsKey(effect)) {
            WeakReference<JDialog> ref = this.map.get(effect);
            JDialog dialog = (JDialog)ref.get();
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
            this.map.remove(effect);
        }
    }

    public void openEffectEditor(Frame root, Effect effect) {
        JDialog dialog = null;
        WeakReference<JDialog> ref = this.map.get(effect);
        if (ref != null) {
            dialog = (JDialog)ref.get();
        }
        if (dialog == null) {
            dialog = new JDialog(root);
            JFXPanel panel = new JFXPanel();
            CountDownLatch latch = new CountDownLatch(1);
            double[] dims = new double[2];
            BlueFX.runOnFXThread(() -> {
                try {
                    BSBEditPane editPanel = new BSBEditPane(BSBObjectRegistry.getBSBObjects(), false);
                    editPanel.editBSBGraphicInterface(effect.getGraphicInterface());
                    Scene scene = new Scene((Parent)editPanel);
                    BlueFX.style((Scene)scene);
                    panel.setScene(scene);
                }
                finally {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            dialog.getContentPane().add((Component)panel);
            dialog.setTitle(effect.getName());
            dialog.getRootPane().putClientProperty("SeparateWindow", Boolean.TRUE);
            dialog.setVisible(true);
            JDialog dlg = dialog;
            SwingUtilities.invokeLater(() -> {
                dlg.pack();
                dlg.setSize(dlg.getWidth() + 5, dlg.getHeight() + 5);
            });
            this.map.put(effect, new WeakReference<JDialog>(dialog));
        } else {
            dialog.setVisible(true);
        }
    }

    public void updateEffectInterface(Effect effect) {
        JDialog dialog = null;
        WeakReference<JDialog> ref = this.map.get(effect);
        if (ref != null) {
            dialog = (JDialog)ref.get();
        }
        if (dialog != null) {
            JDialog dlg = dialog;
            SwingUtilities.invokeLater(() -> {
                dlg.pack();
                dlg.setSize(dlg.getWidth() + 5, dlg.getHeight() + 5);
            });
        }
    }

    public static EffectEditorManager getInstance() {
        if (manager == null) {
            manager = new EffectEditorManager();
        }
        return manager;
    }
}

