/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor;

import blue.BlueSystem;
import blue.orchestra.BlueSynthBuilder;
import blue.orchestra.Instrument;
import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.BSBObjectRegistry;
import blue.orchestra.blueSynthBuilder.PresetGroup;
import blue.orchestra.editor.InstrumentEditor;
import blue.orchestra.editor.blueSynthBuilder.BSBCodeEditor;
import blue.orchestra.editor.blueSynthBuilder.BSBInterfaceEditor;
import blue.ui.core.udo.EmbeddedOpcodeListPanel;
import java.awt.BorderLayout;
import javafx.application.Platform;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class BlueSynthBuilderEditor
extends InstrumentEditor {
    private BlueSynthBuilder bsb;
    private BSBInterfaceEditor interfaceEditor = new BSBInterfaceEditor(BSBObjectRegistry.getBSBObjects(), true);
    private BSBCodeEditor codeEditor = new BSBCodeEditor();
    private EmbeddedOpcodeListPanel udoPanel = new EmbeddedOpcodeListPanel();
    JLabel label = new JLabel("[ Blue Synth Builder ]");
    JTabbedPane tabs = new JTabbedPane();

    public BlueSynthBuilderEditor() {
        this.tabs.add(BlueSystem.getString((String)"instrument.interface"), this.interfaceEditor);
        this.tabs.add(BlueSystem.getString((String)"instrument.code"), this.codeEditor);
        this.tabs.add(BlueSystem.getString((String)"instrument.udo"), this.udoPanel);
        this.setLayout(new BorderLayout());
        this.add(this.label, "North");
        this.add(this.tabs, "Center");
    }

    public JTabbedPane getTabs() {
        return this.tabs;
    }

    public void setLabelText(String labelText) {
        this.label.setText(labelText);
    }

    public void editInstrument(Instrument instr) {
        if (instr == null) {
            this.bsb = null;
            return;
        }
        if (!(instr instanceof BlueSynthBuilder)) {
            this.bsb = null;
            return;
        }
        this.bsb = (BlueSynthBuilder)instr;
        PresetGroup presetGroup = this.bsb.getPresetGroup();
        BSBGraphicInterface graphicInterface = this.bsb.getGraphicInterface();
        Platform.runLater(() -> this.interfaceEditor.editInterface(graphicInterface, presetGroup));
        this.codeEditor.editBlueSynthBuilder(this.bsb);
        this.udoPanel.editOpcodeList(this.bsb.getOpcodeList());
    }
}

