/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.automation.ParameterLinePanel;
import blue.components.AlphaMarquee;
import blue.score.TimeState;
import blue.score.layers.AutomatableLayer;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.ui.core.score.MultiLineScoreSelection;
import blue.ui.core.score.MultiLineScoreSelectionListener;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.soundLayer.SoundLayerLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.JComponent;

public class AutomationLayerPanel
extends JComponent
implements PropertyChangeListener,
LayerGroupListener,
MultiLineScoreSelectionListener {
    SoundLayerLayout layout = new SoundLayerLayout();
    private LayerGroup layerGroup = null;
    private TimeState timeState = null;
    private AlphaMarquee marquee;
    private int scaleLayerNum = -1;
    MultiLineScoreSelection selection = MultiLineScoreSelection.getInstance();
    final ScorePath path;

    public AutomationLayerPanel(AlphaMarquee marquee) {
        this.setLayout(this.layout);
        this.marquee = marquee;
        this.path = ScoreController.getInstance().getScorePath();
    }

    public void setLayerGroup(LayerGroup layerGroup, TimeState timeState) {
        if (this.layerGroup != null && this.path.getLastLayerGroup() == null) {
            this.timeState.removePropertyChangeListener((PropertyChangeListener)this);
            this.layerGroup.removeLayerGroupListener((LayerGroupListener)this);
        }
        Component[] components = this.getComponents();
        this.removeAll();
        for (int i = 0; i < components.length; ++i) {
            ((ParameterLinePanel)components[i]).cleanup();
        }
        this.layout.setPolyObject(layerGroup);
        this.layerGroup = layerGroup;
        this.timeState = timeState;
        if (layerGroup != null && this.path.getLastLayerGroup() == null) {
            this.timeState.addPropertyChangeListener((PropertyChangeListener)this);
            this.layerGroup.addLayerGroupListener((LayerGroupListener)this);
        }
        this.populate();
    }

    private void populate() {
        if (this.layerGroup == null || this.path.getLastLayerGroup() != null) {
            return;
        }
        for (int i = 0; i < this.layerGroup.size(); ++i) {
            AutomatableLayer sLayer = (AutomatableLayer)this.layerGroup.get(i);
            ParameterLinePanel paramPanel = new ParameterLinePanel(this.marquee);
            paramPanel.setTimeState(this.timeState);
            paramPanel.setParameterIdList(sLayer.getAutomationParameters());
            this.add(paramPanel);
        }
        this.revalidate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.layerGroup && evt.getPropertyName().equals("heightIndex")) {
            this.revalidate();
        }
    }

    @Override
    public void removeNotify() {
        MultiLineScoreSelection.getInstance().removeListener(this);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        MultiLineScoreSelection.getInstance().addListener(this);
    }

    @Override
    public void multiLineSelectionUpdated(MultiLineScoreSelection.UpdateType updateType) {
        switch (updateType) {
            case SELECTION: {
                this.setMultiLineDragStart(this.selection.getStartTime(), this.selection.getEndTime(), this.selection.getSelectedLayers());
                break;
            }
            case TRANSLATION_START: {
                this.setMultiLineDragStart(this.selection.getStartTime(), this.selection.getEndTime(), this.selection.getSelectedLayers());
                break;
            }
            case TRANSLATION: {
                this.setMultiLineTranslation(this.selection.getTranslationTime());
                break;
            }
            case TRANSLATION_COMPLETE: {
                this.commitMultiLineDrag();
                break;
            }
            case CLEAR: {
                this.clearMultiLineTranslation();
            }
        }
    }

    public void setMultiLineDragStart(double startTime, double endTime, Collection<Layer> selectedLayers) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ParameterLinePanel paramLinePanel = (ParameterLinePanel)this.getComponent(i);
            if (selectedLayers != null && selectedLayers.contains(this.layerGroup.get(i))) {
                paramLinePanel.setSelectionDragRegion(startTime, endTime);
                continue;
            }
            paramLinePanel.clearSelectionDragRegions();
        }
    }

    public void commitMultiLineDrag() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ParameterLinePanel paramLinePanel = (ParameterLinePanel)this.getComponent(i);
            paramLinePanel.commitMultiLineDrag();
        }
    }

    public void setMultiLineTranslation(double timeTranslate) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ParameterLinePanel paramLinePanel = (ParameterLinePanel)this.getComponent(i);
            paramLinePanel.setMultiLineMouseTranslation(timeTranslate);
        }
    }

    public void clearMultiLineTranslation() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ParameterLinePanel paramLinePanel = (ParameterLinePanel)this.getComponent(i);
            paramLinePanel.clearSelectionDragRegions();
        }
    }

    public void initiateScoreScale(double startTime, double endTime, int scaleLayerNum) {
        this.scaleLayerNum = scaleLayerNum;
        ParameterLinePanel paramLinePanel = (ParameterLinePanel)this.getComponent(this.scaleLayerNum);
        paramLinePanel.initiateScoreScale(startTime, endTime);
    }

    public void setScoreScaleStart(double newSelectionStartTime) {
        ParameterLinePanel paramLinePanel = (ParameterLinePanel)this.getComponent(this.scaleLayerNum);
        paramLinePanel.setScoreScaleStart(newSelectionStartTime);
    }

    public void setScoreScaleEnd(double newSelectionEndTime) {
        ParameterLinePanel paramLinePanel = (ParameterLinePanel)this.getComponent(this.scaleLayerNum);
        paramLinePanel.setScoreScaleEnd(newSelectionEndTime);
    }

    public void endScoreScale() {
        ParameterLinePanel paramLinePanel = (ParameterLinePanel)this.getComponent(this.scaleLayerNum);
        paramLinePanel.commitScoreScale();
        this.scaleLayerNum = -1;
    }

    public void layerGroupChanged(LayerGroupDataEvent event) {
        switch (event.getType()) {
            case 0: {
                this.layersAdded(event);
                break;
            }
            case 1: {
                this.layersRemoved(event);
                break;
            }
            case 2: {
                this.contentsChanged(event);
            }
        }
    }

    public void contentsChanged(LayerGroupDataEvent e) {
        boolean isUp;
        int start = e.getStartIndex();
        int end = e.getEndIndex();
        boolean bl = isUp = start >= 0 && end >= 0;
        if (isUp) {
            Component c = this.getComponent(start);
            this.remove(start);
            this.add(c, end);
        } else {
            Component c = this.getComponent(-start);
            this.remove(-start);
            this.add(c, -end);
        }
        this.revalidate();
    }

    public void layersAdded(LayerGroupDataEvent e) {
        int index = e.getStartIndex();
        AutomatableLayer sLayer = (AutomatableLayer)this.layerGroup.get(index);
        ParameterLinePanel paramPanel = new ParameterLinePanel(this.marquee);
        paramPanel.setTimeState(this.timeState);
        paramPanel.setParameterIdList(sLayer.getAutomationParameters());
        this.add((Component)paramPanel, index);
        this.revalidate();
    }

    public void layersRemoved(LayerGroupDataEvent e) {
        int end;
        int start = e.getStartIndex();
        for (int i = end = e.getEndIndex(); i >= start; --i) {
            Component c = this.getComponent(i);
            this.remove(i);
            ((ParameterLinePanel)c).cleanup();
        }
        this.revalidate();
    }
}

