/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.BlueData;
import blue.SoundObjectLibrary;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.score.ScoreObject;
import blue.soundObject.Instance;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.layers.SoundObjectProvider;
import blue.ui.core.score.layers.soundObject.SoundObjectLibraryTableModel;
import blue.ui.core.score.layers.soundObject.SoundObjectLibraryUtils;
import blue.ui.core.score.layers.soundObject.UserSoundObjectLibrary;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="SoundObjectLibraryTopComponent", persistenceType=0)
public final class SoundObjectLibraryTopComponent
extends TopComponent
implements ChangeListener,
SoundObjectProvider {
    private static SoundObjectLibraryTopComponent instance;
    private final InstanceContent content = new InstanceContent();
    private SoundObjectLibrary sObjLib = new SoundObjectLibrary();
    final ScoreController.ScoreObjectBuffer scoreObjectBuffer = ScoreController.getInstance().getScoreObjectBuffer();
    private JButton copyButton;
    private JButton copyInstanceButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JTable sObjLibTable;
    private JSplitPane splitPane;

    private SoundObjectLibraryTopComponent() {
        this.initComponents();
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.content));
        this.setName(NbBundle.getMessage(SoundObjectLibraryTopComponent.class, (String)"CTL_SoundObjectLibraryTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SoundObjectLibraryTopComponent.class, (String)"HINT_SoundObjectLibraryTopComponent"));
        this.sObjLibTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = SoundObjectLibraryTopComponent.this.sObjLibTable.getSelectedRow();
                if (index != -1) {
                    SoundObject sObj = SoundObjectLibraryTopComponent.this.sObjLib.getSoundObject(index);
                    if (e.getClickCount() >= 2) {
                        SoundObjectLibraryTopComponent.this.fireSoundObjectSelected(sObj);
                    }
                }
            }
        });
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.reinitialize();
        this.splitPane.setRightComponent(new UserSoundObjectLibrary(this.content));
        this.splitPane.setDividerLocation(200);
    }

    public void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        if (project != null) {
            BlueData currentData = project.getData();
            this.setSoundObjectLibrary(currentData.getSoundObjectLibrary());
        }
    }

    protected void fireSoundObjectSelected(SoundObject sObj) {
        this.content.set(Collections.singleton(sObj), null);
    }

    protected void fireSoundObjectRemoved(SoundObject sObj) {
        this.content.set(Collections.emptyList(), null);
    }

    public void setSoundObjectLibrary(SoundObjectLibrary sObjLib) {
        if (this.sObjLib != null) {
            this.sObjLib.removeChangeListener((ChangeListener)this);
        }
        this.sObjLib = sObjLib;
        this.sObjLibTable.setModel(new SoundObjectLibraryTableModel(sObjLib));
        this.sObjLibTable.setSelectionMode(0);
        this.sObjLibTable.setColumnSelectionAllowed(true);
        this.setColumnWidth(0, 20);
        this.setColumnWidth(1, 80);
        this.sObjLibTable.getTableHeader().setReorderingAllowed(false);
        if (this.sObjLib != null) {
            this.sObjLib.addChangeListener((ChangeListener)this);
        }
    }

    public boolean containsSoundObject(SoundObject soundObject) {
        if (this.sObjLib == null) {
            return false;
        }
        return this.sObjLib.contains((Object)soundObject);
    }

    private void setColumnWidth(int columnNum, int width) {
        this.sObjLibTable.getTableHeader().getColumnModel().getColumn(columnNum).setPreferredWidth(width);
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.copyButton = new JButton();
        this.copyInstanceButton = new JButton();
        this.removeButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sObjLibTable = new JTable();
        this.splitPane.setOrientation(0);
        Mnemonics.setLocalizedText((AbstractButton)this.copyButton, (String)NbBundle.getMessage(SoundObjectLibraryTopComponent.class, (String)"SoundObjectLibraryTopComponent.copyButton.text"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundObjectLibraryTopComponent.this.copyButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.copyButton);
        Mnemonics.setLocalizedText((AbstractButton)this.copyInstanceButton, (String)NbBundle.getMessage(SoundObjectLibraryTopComponent.class, (String)"SoundObjectLibraryTopComponent.copyInstanceButton.text"));
        this.copyInstanceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundObjectLibraryTopComponent.this.copyInstanceButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.copyInstanceButton);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(SoundObjectLibraryTopComponent.class, (String)"SoundObjectLibraryTopComponent.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundObjectLibraryTopComponent.this.removeButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.removeButton);
        this.sObjLibTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.sObjLibTable);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 27, Short.MAX_VALUE).addContainerGap()));
        this.splitPane.setLeftComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, GroupLayout.Alignment.TRAILING));
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        int index = this.sObjLibTable.getSelectedRow();
        if (index != -1) {
            SoundObject sObj = this.sObjLib.getSoundObject(index);
            SoundObject tempSObj = sObj.deepCopy();
            ScoreController.getInstance().setSelectedScoreObjects(Collections.singleton(tempSObj));
            this.scoreObjectBuffer.clear();
            this.scoreObjectBuffer.scoreObjects.add((ScoreObject)tempSObj);
            this.scoreObjectBuffer.layerIndexes.add(0);
        }
    }

    private void copyInstanceButtonActionPerformed(ActionEvent evt) {
        int index = this.sObjLibTable.getSelectedRow();
        if (index != -1) {
            SoundObject originalSObj = this.sObjLib.getSoundObject(index);
            Instance tempSObj = new Instance(originalSObj);
            tempSObj.setStartTime(0.0);
            tempSObj.setSubjectiveDuration(tempSObj.getObjectiveDuration());
            ScoreController.getInstance().setSelectedScoreObjects(Collections.singleton(tempSObj));
            this.scoreObjectBuffer.clear();
            this.scoreObjectBuffer.scoreObjects.add((ScoreObject)tempSObj);
            this.scoreObjectBuffer.layerIndexes.add(0);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        if (this.sObjLibTable.getSelectedRow() != -1) {
            NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)"Removing this SoundObject will remove all Instances of it within your project.  Please confirm this operation. (This can not be undone.)", 1);
            Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            if (retVal == NotifyDescriptor.YES_OPTION) {
                SoundObject sObj = this.sObjLib.getSoundObject(this.sObjLibTable.getSelectedRow());
                SoundObjectLibraryUtils.removeLibrarySoundObject(BlueProjectManager.getInstance().getCurrentBlueData(), sObj);
                this.fireSoundObjectRemoved(sObj);
                this.sObjLibTable.revalidate();
            }
        }
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.sObjLibTable.revalidate();
    }
}

