/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.score.ScoreObjectEvent;
import blue.score.ScoreObjectListener;
import blue.score.TimeState;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScoreObjectView;
import blue.ui.core.score.ScoreTopComponent;
import blue.ui.core.soundObject.renderer.BarRenderer;
import blue.ui.core.soundObject.renderer.BarRendererCache;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.util.Collection;
import javax.swing.JComponent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.WindowManager;

public final class SoundObjectView
extends JComponent
implements Comparable<SoundObjectView>,
ScoreObjectListener,
LookupListener,
ScoreObjectView<SoundObject> {
    private SoundObject sObj;
    boolean selected = false;
    private TimeState timeState;
    BarRenderer renderer = null;
    Lookup.Result<SoundObject> result = null;

    public SoundObjectView(SoundObject sObj, TimeState timeState) {
        this.sObj = sObj;
        this.timeState = timeState;
        this.renderer = BarRendererCache.getInstance().getBarRenderer(this.sObj.getClass());
        this.sObj.addScoreObjectListener((ScoreObjectListener)this);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void cleanup() {
        if (this.sObj != null) {
            this.sObj.removeScoreObjectListener((ScoreObjectListener)this);
            this.renderer.cleanup(this);
            this.timeState = null;
            this.sObj = null;
        }
    }

    private void init() {
        this.setBounds(-1, 0, (int)(this.sObj.getSubjectiveDuration() * (double)this.timeState.getPixelSecond()), 22);
        this.setLayout(new BorderLayout());
        this.setDoubleBuffered(true);
    }

    private void updateView() {
        this.updateView(this.getY(), this.getHeight());
    }

    public void updateView(int newY, int newHeight) {
        this.setLocation((int)(this.getStartTime() * (double)this.timeState.getPixelSecond()), newY);
        this.setSize((int)(this.getSubjectiveDuration() * (double)this.timeState.getPixelSecond()), newHeight);
    }

    public void setStartTime(double yo) {
        this.sObj.setStartTime(yo);
    }

    public double getStartTime() {
        return this.sObj.getStartTime();
    }

    public double getSubjectiveDuration() {
        return this.sObj.getSubjectiveDuration();
    }

    public void setSubjectiveTime(double yo) {
        this.sObj.setSubjectiveDuration(yo);
    }

    public SoundObject getSoundObject() {
        return this.sObj;
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.renderer != null && this.timeState != null) {
            this.renderer.render(graphics, this, this.timeState.getPixelSecond());
        }
    }

    @Override
    public int compareTo(SoundObjectView sObjView) {
        int x2;
        int x1 = this.getX();
        if (x1 > (x2 = sObjView.getX())) {
            return 1;
        }
        if (x1 < x2) {
            return -1;
        }
        return 0;
    }

    public void scoreObjectChanged(ScoreObjectEvent event) {
        if (event == null || event.getScoreObject() != this.sObj) {
            return;
        }
        switch (event.getPropertyChanged()) {
            case 0: {
                this.repaint();
                break;
            }
            case 1: 
            case 2: {
                this.updateView();
                break;
            }
            case 3: {
                this.repaint();
                break;
            }
            case 4: {
                this.repaint();
            }
        }
    }

    public BarRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ScoreTopComponent scoreTopComponent = (ScoreTopComponent)WindowManager.getDefault().findTopComponent("ScoreTopComponent");
        this.result = scoreTopComponent.getLookup().lookupResult(SoundObject.class);
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    public void resultChanged(LookupEvent ev) {
        Collection soundObjects;
        boolean newSelected;
        if (this.result != null && (newSelected = (soundObjects = this.result.allInstances()).contains(this.sObj)) != this.selected) {
            this.selected = newSelected;
            this.repaint();
        }
    }

    @Override
    public SoundObject getScoreObject() {
        return this.sObj;
    }
}

