/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.mouse;

import blue.components.AlphaMarquee;
import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.ui.core.render.RealtimeRenderManager;
import blue.ui.core.score.ModeManager;
import blue.ui.core.score.MultiLineScoreSelection;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScoreMode;
import blue.ui.core.score.mouse.BlueMouseAdapter;
import blue.utility.ScoreUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.SwingUtilities;

class MultiLineMoveMouseListener
extends BlueMouseAdapter {
    private Rectangle scrollRect = new Rectangle(0, 0, 1, 1);
    int startX = -1;
    double minTranslation = 0.0;
    private ScoreObject[] selectedScoreObjects = null;
    private double[] startTimes = null;
    TimeState timeState = null;
    MultiLineScoreSelection selection = MultiLineScoreSelection.getInstance();

    MultiLineMoveMouseListener() {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isMultiLineMode()) {
            return;
        }
        AlphaMarquee marquee = scoreTC.getMarquee();
        Point p = SwingUtilities.convertPoint(scoreTC.getScorePanel(), e.getPoint(), marquee);
        if (!marquee.isVisible() || !marquee.contains(p)) {
            return;
        }
        e.consume();
        RealtimeRenderManager.getInstance().stopAuditioning();
        this.timeState = scoreTC.getTimeState();
        this.startX = e.getX();
        this.minTranslation = -this.selection.getStartTime();
        Collection<? extends ScoreObject> selectedObjects = ScoreController.getInstance().getSelectedScoreObjects();
        this.selectedScoreObjects = selectedObjects.toArray(new ScoreObject[0]);
        this.startTimes = new double[this.selectedScoreObjects.length];
        for (int i = 0; i < this.selectedScoreObjects.length; ++i) {
            ScoreObject sObj = this.selectedScoreObjects[i];
            this.startTimes[i] = sObj.getStartTime();
            this.minTranslation = Math.max(this.minTranslation, -this.startTimes[i]);
        }
        this.selection.startTranslation();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isMultiLineMode()) {
            return;
        }
        e.consume();
        AlphaMarquee marquee = scoreTC.getMarquee();
        if (SwingUtilities.isLeftMouseButton(e)) {
            int x = e.getX();
            int diffX = x - this.startX;
            double translation = (double)diffX / (double)this.timeState.getPixelSecond();
            if (this.timeState.isSnapEnabled() && !e.isControlDown()) {
                double newTime = ScoreUtilities.getSnapValueMove((double)(-this.minTranslation + translation), (double)this.timeState.getSnapValue());
                translation = newTime + this.minTranslation;
            }
            translation = Math.max(translation, this.minTranslation);
            this.selection.updateTranslation(translation);
            int marqueeX = (int)((marquee.startTime + translation) * (double)this.timeState.getPixelSecond());
            marquee.setLocation(marqueeX, marquee.getY());
            for (int i = 0; i < this.selectedScoreObjects.length; ++i) {
                ScoreObject sObj = this.selectedScoreObjects[i];
                sObj.setStartTime(this.startTimes[i] + translation);
            }
        }
        this.checkScroll(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
        if (SwingUtilities.isLeftMouseButton(e)) {
            AlphaMarquee marquee = scoreTC.getMarquee();
            marquee.startTime += this.selection.getTranslationTime();
            marquee.endTime += this.selection.getTranslationTime();
            this.selection.endTranslation();
        }
        this.timeState = null;
    }

    private boolean isMultiLineMode() {
        return ModeManager.getInstance().getMode() == ScoreMode.MULTI_LINE;
    }

    private void checkScroll(MouseEvent e) {
        Point temp = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), scoreTC.getScorePanel());
        this.scrollRect.setLocation(temp);
        scoreTC.getScorePanel().scrollRectToVisible(this.scrollRect);
    }

    @Override
    public boolean acceptsMode(ScoreMode mode) {
        return mode == ScoreMode.MULTI_LINE;
    }
}

