/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.mouse;

import blue.components.AlphaMarquee;
import blue.score.TimeState;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import blue.score.layers.ScoreObjectLayer;
import blue.ui.core.render.RealtimeRenderManager;
import blue.ui.core.score.ModeManager;
import blue.ui.core.score.MultiLineScoreSelection;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScoreMode;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.layers.LayerGroupPanel;
import blue.ui.core.score.mouse.BlueMouseAdapter;
import blue.ui.utilities.UiUtilities;
import blue.utility.ScoreUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;

class MultiLineSelectionMouseProcessor
extends BlueMouseAdapter {
    private Rectangle scrollRect = new Rectangle(0, 0, 1, 1);
    Layer startLayer = null;
    Layer lastLayer = null;
    List<Layer> allLayers = null;
    int startX = -1;
    int[] startTopBottom = null;
    TimeState timeState = null;
    MultiLineScoreSelection selection = MultiLineScoreSelection.getInstance();

    MultiLineSelectionMouseProcessor() {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isMultiLineMode()) {
            return;
        }
        AlphaMarquee marquee = scoreTC.getMarquee();
        Point p = SwingUtilities.convertPoint(scoreTC.getScorePanel(), e.getPoint(), marquee);
        if (marquee.isVisible() && marquee.contains(p)) {
            return;
        }
        e.consume();
        RealtimeRenderManager.getInstance().stopAuditioning();
        this.timeState = scoreTC.getTimeState();
        ScorePath scorePath = ScoreController.getInstance().getScorePath();
        Layer layer = scorePath.getGlobalLayerForY(e.getY());
        if (layer == null || !(layer instanceof ScoreObjectLayer)) {
            marquee.setVisible(false);
            return;
        }
        this.startLayer = this.lastLayer = layer;
        this.allLayers = scorePath.getAllLayers();
        if (!UiUtilities.isRightMouseButton((MouseEvent)e) && SwingUtilities.isLeftMouseButton(e)) {
            this.startX = Math.max(e.getX(), 0);
            double startTime = (double)this.startX / (double)this.timeState.getPixelSecond();
            if (this.timeState.isSnapEnabled()) {
                startTime = ScoreUtilities.getSnapValueStart((double)startTime, (double)this.timeState.getSnapValue());
                this.startX = (int)(startTime * (double)this.timeState.getPixelSecond());
            }
            this.startTopBottom = this.getTopBottomForLayer(layer, (List<LayerGroup<? extends Layer>>)scorePath.getScore());
            scoreTC.getMarquee().setStart(new Point(this.startX, this.startTopBottom[0]));
            scoreTC.getMarquee().setVisible(true);
            ScoreController.getInstance().setSelectedScoreObjects(null);
            this.selection.reset();
            this.selection.startSelection(startTime, startTime);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isMultiLineMode()) {
            return;
        }
        e.consume();
        AlphaMarquee marquee = scoreTC.getMarquee();
        if (SwingUtilities.isLeftMouseButton(e)) {
            int endLayerIndex;
            int startLayerIndex;
            int bottomY;
            int topY;
            int rightX;
            int leftX;
            ScorePath scorePath;
            Layer layer;
            int x = Math.max(e.getX(), 0);
            double mouseDragTime = (double)x / (double)this.timeState.getPixelSecond();
            if (this.timeState.isSnapEnabled()) {
                mouseDragTime = ScoreUtilities.getSnapValueMove((double)mouseDragTime, (double)this.timeState.getSnapValue());
                x = (int)(mouseDragTime * (double)this.timeState.getPixelSecond());
            }
            if ((layer = (scorePath = ScoreController.getInstance().getScorePath()).getGlobalLayerForY(e.getY())) != null && layer instanceof ScoreObjectLayer) {
                this.lastLayer = layer;
            }
            int[] topBottom = this.getTopBottomForLayer(this.lastLayer, (List<LayerGroup<? extends Layer>>)scorePath.getScore());
            if (x < this.startX) {
                leftX = x;
                rightX = this.startX;
            } else {
                leftX = this.startX;
                rightX = x;
            }
            if (topBottom[0] < this.startTopBottom[0]) {
                topY = topBottom[0];
                bottomY = this.startTopBottom[1];
                startLayerIndex = this.allLayers.indexOf(this.lastLayer);
                endLayerIndex = this.allLayers.indexOf(this.startLayer);
            } else {
                topY = this.startTopBottom[0];
                bottomY = topBottom[1];
                startLayerIndex = this.allLayers.indexOf(this.startLayer);
                endLayerIndex = this.allLayers.indexOf(this.lastLayer);
            }
            leftX = Math.max(leftX, 0);
            topY = Math.max(topY, 0);
            marquee.setStart(new Point(leftX, topY));
            marquee.setDragPoint(new Point(rightX, bottomY));
            double start = (double)leftX / (double)this.timeState.getPixelSecond();
            double end = (double)rightX / (double)this.timeState.getPixelSecond();
            marquee.startTime = start;
            marquee.endTime = end;
            List<Layer> currentLayers = this.allLayers.subList(startLayerIndex, endLayerIndex + 1);
            this.selection.updateSelection(start, end, currentLayers);
        }
        this.checkScroll(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isMultiLineMode()) {
            return;
        }
        e.consume();
        ScoreController.getInstance().setSelectedScoreObjects(null);
        if (SwingUtilities.isLeftMouseButton(e)) {
            Component[] comps;
            for (Component c : comps = scoreTC.getLayerPanel().getComponents()) {
                if (!(c instanceof LayerGroupPanel)) continue;
                ((LayerGroupPanel)((Object)c)).marqueeSelectionPerformed(scoreTC.getMarquee());
            }
        }
        this.timeState = null;
    }

    private boolean isMultiLineMode() {
        return ModeManager.getInstance().getMode() == ScoreMode.MULTI_LINE;
    }

    private void checkScroll(MouseEvent e) {
        Point temp = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), scoreTC.getScorePanel());
        this.scrollRect.setLocation(temp);
        scoreTC.getScorePanel().scrollRectToVisible(this.scrollRect);
    }

    protected int[] getTopBottomForLayer(Layer targetLayer, List<LayerGroup<? extends Layer>> allLayers) {
        int runningY = 0;
        for (LayerGroup<? extends Layer> layerGroup : allLayers) {
            for (Layer layer : layerGroup) {
                if (layer == targetLayer) {
                    return new int[]{runningY, runningY + layer.getLayerHeight()};
                }
                runningY += layer.getLayerHeight();
            }
            runningY += 36;
        }
        return null;
    }

    @Override
    public boolean acceptsMode(ScoreMode mode) {
        return mode == ScoreMode.MULTI_LINE;
    }
}

