/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.score.ScoreObject;
import blue.ui.core.score.object.actions.AlignRightAction;
import blue.ui.core.score.undo.AlignEdit;
import blue.undo.BlueUndoManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.UndoableEdit;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class AlignLeftAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends ScoreObject> selected;

    public AlignLeftAction() {
        this((Collection<? extends ScoreObject>)null);
    }

    public AlignLeftAction(Collection<? extends ScoreObject> soundObjects) {
        super(NbBundle.getMessage(AlignRightAction.class, (String)"CTL_AlignLeftAction"));
        this.selected = soundObjects;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.selected.size() < 2) {
            return;
        }
        double[] initialStartTimes = new double[this.selected.size()];
        double[] endingStartTimes = new double[this.selected.size()];
        double farLeft = Double.MAX_VALUE;
        int i = 0;
        for (ScoreObject scoreObject : this.selected) {
            initialStartTimes[i] = scoreObject.getStartTime();
            if (initialStartTimes[i] < farLeft) {
                farLeft = initialStartTimes[i];
            }
            ++i;
        }
        i = 0;
        for (ScoreObject scoreObject : this.selected) {
            scoreObject.setStartTime(farLeft);
            endingStartTimes[i] = farLeft;
            ++i;
        }
        BlueUndoManager.setUndoManager((String)"score");
        AlignEdit edit = new AlignEdit(this.selected.toArray(new ScoreObject[0]), initialStartTimes, endingStartTimes);
        edit.setPresentationName("Align Left");
        BlueUndoManager.addEdit((UndoableEdit)edit);
    }

    @Override
    public boolean isEnabled() {
        return this.selected.size() > 1;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new AlignLeftAction(actionContext.lookupAll(ScoreObject.class));
    }
}

