/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.SoundLayer;
import blue.score.ScoreObject;
import blue.soundObject.External;
import blue.soundObject.ObjectBuilder;
import blue.soundObject.PythonObject;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ConvertToObjectBuilderAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends SoundObject> soundObjects;
    private final Collection<? extends ScoreObject> scoreObjects;
    private final Point p;
    private final ScorePath scorePath;

    public ConvertToObjectBuilderAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ConvertToObjectBuilderAction(Lookup lookup) {
        super(NbBundle.getMessage(ConvertToObjectBuilderAction.class, (String)"CTL_ConvertToObjectBuilderAction"));
        this.soundObjects = lookup.lookupAll(SoundObject.class);
        this.scoreObjects = lookup.lookupAll(ScoreObject.class);
        this.p = (Point)lookup.lookup(Point.class);
        this.scorePath = (ScorePath)lookup.lookup(ScorePath.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SoundObject temp = this.soundObjects.iterator().next();
        int retVal = JOptionPane.showConfirmDialog(null, "This operation can not be undone.\nAre you sure?");
        if (retVal != 0) {
            return;
        }
        SoundLayer layer = (SoundLayer)this.scorePath.getGlobalLayerForY(this.p.y);
        ObjectBuilder objBuilder = new ObjectBuilder();
        if (temp instanceof PythonObject) {
            PythonObject tempPython = (PythonObject)temp;
            objBuilder.setName(tempPython.getName());
            objBuilder.setNoteProcessorChain(tempPython.getNoteProcessorChain());
            objBuilder.setTimeBehavior(tempPython.getTimeBehavior());
            objBuilder.setStartTime(tempPython.getStartTime());
            objBuilder.setSubjectiveDuration(tempPython.getSubjectiveDuration());
            objBuilder.setCode(tempPython.getText());
            objBuilder.setBackgroundColor(tempPython.getBackgroundColor());
        } else if (temp instanceof External) {
            External tempExt = (External)temp;
            objBuilder.setName(tempExt.getName());
            objBuilder.setNoteProcessorChain(tempExt.getNoteProcessorChain());
            objBuilder.setTimeBehavior(tempExt.getTimeBehavior());
            objBuilder.setStartTime(tempExt.getStartTime());
            objBuilder.setSubjectiveDuration(tempExt.getSubjectiveDuration());
            objBuilder.setCode(tempExt.getText());
            objBuilder.setCommandLine(tempExt.getCommandLine());
            objBuilder.setLanguageType(ObjectBuilder.LanguageType.EXTERNAL);
            objBuilder.setBackgroundColor(tempExt.getBackgroundColor());
        } else {
            return;
        }
        layer.remove((ScoreObject)temp);
        layer.add((SoundObject)objBuilder);
        ScoreController.getInstance().removeSelectedScoreObject((ScoreObject)temp);
        ScoreController.getInstance().addSelectedScoreObject((ScoreObject)objBuilder);
    }

    @Override
    public boolean isEnabled() {
        if (this.scoreObjects.size() != this.soundObjects.size() || this.soundObjects.size() != 1) {
            return false;
        }
        SoundObject sObj = this.soundObjects.iterator().next();
        return sObj instanceof PythonObject || sObj instanceof External;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ConvertToObjectBuilderAction(actionContext);
    }
}

