/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.SoundLayer;
import blue.score.ScoreObject;
import blue.score.layers.Layer;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.object.actions.AlignRightAction;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ConvertToPolyObjectAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends ScoreObject> scoreObjects;
    private final Collection<? extends SoundObject> soundObjects;
    private final Point p;
    private PolyObject pObj = new PolyObject();
    private final ScorePath scorePath;

    public ConvertToPolyObjectAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ConvertToPolyObjectAction(Lookup lookup) {
        super(NbBundle.getMessage(AlignRightAction.class, (String)"CTL_ConvertToPolyObjectAction"));
        this.soundObjects = lookup.lookupAll(SoundObject.class);
        this.scoreObjects = lookup.lookupAll(ScoreObject.class);
        this.p = (Point)lookup.lookup(Point.class);
        this.scorePath = (ScorePath)lookup.lookup(ScorePath.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        void var11_15;
        void var11_13;
        int retVal = JOptionPane.showConfirmDialog(null, "This operation can not be undone.\nAre you sure?");
        if (retVal != 0) {
            return;
        }
        List<Layer> allLayers = this.scorePath.getAllLayers();
        ArrayList<SoundObject> sObjList = new ArrayList<SoundObject>();
        ArrayList<Integer> layerIndexes = new ArrayList<Integer>();
        int layerMin = Integer.MAX_VALUE;
        int layerMax = Integer.MIN_VALUE;
        double start = Double.POSITIVE_INFINITY;
        for (SoundObject soundObject : this.soundObjects) {
            sObjList.add(soundObject);
            double sObjStart = soundObject.getStartTime();
            if (soundObject.getStartTime() < start) {
                start = soundObject.getStartTime();
            }
            for (int i2 = 0; i2 < allLayers.size(); ++i2) {
                if (!allLayers.get(i2).contains((ScoreObject)soundObject)) continue;
                layerIndexes.add(i2);
                if (i2 < layerMin) {
                    layerMin = i2;
                }
                if (i2 <= layerMax) break;
                layerMax = i2;
                break;
            }
            if (sObjList.size() == layerIndexes.size()) continue;
            throw new RuntimeException("Error: Unable to find layer for SoundObject.");
        }
        int numLayers = layerMax - layerMin + 1;
        boolean bl = false;
        while (var11_13 < numLayers) {
            this.pObj.newLayerAt(-1);
            ++var11_13;
        }
        boolean bl2 = false;
        while (var11_15 < sObjList.size()) {
            SoundObject sObj = (SoundObject)sObjList.get((int)var11_15);
            int layerNum = (Integer)layerIndexes.get((int)var11_15);
            SoundLayer layer = (SoundLayer)allLayers.get(layerNum);
            layer.remove((ScoreObject)sObj);
            ((SoundLayer)this.pObj.get(layerNum - layerMin)).add(sObj);
            ++var11_15;
        }
        this.pObj.normalizeSoundObjects();
        this.pObj.setStartTime(start);
        ((SoundLayer)this.scorePath.getGlobalLayerForY(this.p.y)).add((SoundObject)this.pObj);
        ScoreController.getInstance().setSelectedScoreObjects(Collections.singleton(this.pObj));
    }

    @Override
    public boolean isEnabled() {
        Layer layer = this.scorePath.getGlobalLayerForY(this.p.y);
        return this.soundObjects.size() > 0 && this.scoreObjects.size() == this.soundObjects.size() && layer != null && layer.accepts((ScoreObject)this.pObj);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ConvertToPolyObjectAction(actionContext);
    }
}

