/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.tools.csoundrc;

import blue.utilities.TextUtilities;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CsoundRCDialog
extends JDialog {
    File csrcFile = null;
    private JButton closeButton;
    private JLabel fileLabel;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JButton saveButton;

    public CsoundRCDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.openCsoundRC();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.saveButton = new JButton();
        this.closeButton = new JButton();
        this.fileLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(CsoundRCDialog.class, (String)"CsoundRCDialog.title"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.saveButton.setText(NbBundle.getMessage(CsoundRCDialog.class, (String)"CsoundRCDialog.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsoundRCDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText(NbBundle.getMessage(CsoundRCDialog.class, (String)"CsoundRCDialog.closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsoundRCDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.fileLabel.setText(NbBundle.getMessage(CsoundRCDialog.class, (String)"CsoundRCDialog.fileLabel.text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 451, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.fileLabel, -1, 282, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 175, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.saveButton).addComponent(this.fileLabel, -2, 21, -2)).addContainerGap()));
        this.pack();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        String text = this.jTextArea1.getText();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.csrcFile)));
            out.print(text);
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.dispose();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(CsoundRCDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> {
            CsoundRCDialog dialog = new CsoundRCDialog((Frame)new JFrame(), true);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            dialog.setVisible(true);
        });
    }

    private void openCsoundRC() {
        String csoundRc = System.getenv("CSOUNDRC");
        String text = "";
        if (csoundRc != null) {
            this.csrcFile = new File(csoundRc);
        } else {
            String home = System.getenv("HOME");
            this.csrcFile = new File(home + File.separator + ".csound6rc");
        }
        if (this.csrcFile.exists()) {
            try {
                text = TextUtilities.getTextFromFile((File)this.csrcFile);
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.jTextArea1.setText(text);
        this.jTextArea1.setCaretPosition(0);
        this.fileLabel.setText(this.csrcFile.getAbsolutePath());
    }
}

