/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.filemanager;

import blue.ui.filemanager.FileManagerRoots;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class FileNode
extends AbstractNode {
    private final File file;
    private boolean useFullName;
    private final FileManagerRoots roots;
    private FileChildFactory childFactory = null;

    public FileNode(File f, boolean useFullName, FileManagerRoots roots) {
        super(Children.LEAF, Lookups.singleton((Object)f));
        if (f.isDirectory()) {
            this.childFactory = new FileChildFactory(f, roots);
            this.setChildren(Children.create((ChildFactory)this.childFactory, (boolean)true));
        }
        this.file = f;
        this.useFullName = useFullName;
        this.roots = roots;
        this.setDisplayName(useFullName ? f.getAbsolutePath() : f.getName());
    }

    public Action[] getActions(boolean context) {
        List list = null;
        if (this.roots.customRootsContains(this.file)) {
            list = Utilities.actionsForPath((String)"blue/fileManager/roots/actions");
        } else if (!this.roots.staticRootsContains(this.file)) {
            list = Utilities.actionsForPath((String)"blue/fileManager/folder/actions");
        } else {
            return null;
        }
        return list.toArray(new Action[0]);
    }

    public File getFile() {
        return this.file;
    }

    public FileManagerRoots getRoots() {
        return this.roots;
    }

    public void refresh() {
        if (this.childFactory != null) {
            this.childFactory.refreshChildren();
        }
    }

    static class FileChildFactory
    extends ChildFactory<File> {
        private final File file;
        private final FileManagerRoots roots;

        public FileChildFactory(File f, FileManagerRoots roots) {
            this.file = f;
            this.roots = roots;
        }

        public void refreshChildren() {
            super.refresh(true);
        }

        protected boolean createKeys(List<File> toPopulate) {
            List<File> files = Arrays.asList(this.file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.getName().startsWith(".");
                }
            }));
            Collections.sort(files);
            toPopulate.addAll(files);
            return true;
        }

        protected Node createNodeForKey(File key) {
            return new FileNode(key, false, this.roots);
        }
    }
}

