/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.Lex;
import electric.xml.Child;
import electric.xml.Element;
import electric.xml.Parent;
import java.io.IOException;
import java.io.Writer;

public class Text
extends Child {
    static final char[] specials = new char[]{'&', '<', '>', '\'', '\"'};
    static final String[] substitutes = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"};
    String string;
    boolean raw;

    public Text(String string) {
        this.string = string;
    }

    public Text(Text text) {
        this.string = text.string;
    }

    Text(Lex lex, StringBuffer stringBuffer, Element element) throws IOException {
        super(element);
        String string = lex.readToPattern("<", 72);
        this.string = stringBuffer == null ? string : stringBuffer.append(string).toString();
    }

    Text(Parent parent) {
        super(parent);
    }

    public Object clone() {
        return new Text(this);
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setRaw(boolean bl) {
        this.raw = bl;
    }

    public boolean getRaw() {
        return this.raw;
    }

    public void write(Writer writer, int n) throws IOException {
        this.indent(writer, n);
        if (this.raw) {
            writer.write(this.string);
        } else {
            Text.writeWithSubstitution(writer, this.string);
        }
    }

    private static int getSpecialIndex(char c) {
        for (int i = 0; i < specials.length; ++i) {
            if (specials[i] != c) continue;
            return i;
        }
        return -1;
    }

    static void writeWithSubstitution(Writer writer, String string) throws IOException {
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n2 = Text.getSpecialIndex(cArray[i]);
            if (n2 < 0) continue;
            if (n < i) {
                writer.write(cArray, n, i - n);
            }
            writer.write(substitutes[n2]);
            n = i + 1;
        }
        if (n < cArray.length) {
            writer.write(cArray, n, cArray.length - n);
        }
    }
}

