/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.automation.Parameter;
import blue.automation.ParameterListener;
import blue.automation.ParameterTimeManagerFactory;
import blue.orchestra.blueSynthBuilder.AutomatableBSBObject;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.ClampedValue;
import blue.orchestra.blueSynthBuilder.ClampedValueListener;
import blue.orchestra.blueSynthBuilder.Randomizable;
import blue.utility.NumberUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class BSBHSlider
extends AutomatableBSBObject
implements ParameterListener,
Randomizable {
    ClampedValueListener cvl = (pType, bType) -> {
        Parameter p;
        if (this.parameters != null && (p = this.parameters.getParameter(this.getObjectName())) != null) {
            this.updateParameter(this.getValueProperty(), p, pType, bType);
        }
    };
    private ClampedValue value;
    private IntegerProperty sliderWidth = new SimpleIntegerProperty(150);
    private BooleanProperty randomizable = new SimpleBooleanProperty(true);
    private BooleanProperty valueDisplayEnabled = new SimpleBooleanProperty(true);

    public BSBHSlider() {
        this.value = new ClampedValue(0.0, 1.0, 0.0, new BigDecimal("0.1"));
        this.value.addListener(this.cvl);
    }

    public BSBHSlider(BSBHSlider slider) {
        super(slider);
        this.value = new ClampedValue(slider.value);
        this.value.addListener(this.cvl);
        this.setSliderWidth(slider.getSliderWidth());
        this.setRandomizable(slider.isRandomizable());
        this.setValueDisplayEnabled(slider.isValueDisplayEnabled());
    }

    public final void setMinimum(double val) {
        this.value.setMin(val);
    }

    public final double getMinimum() {
        return this.value.getMin();
    }

    public final DoubleProperty minimumProperty() {
        return this.value.minProperty();
    }

    public final void setMaximum(double val) {
        this.value.setMax(val);
    }

    public final double getMaximum() {
        return this.value.getMax();
    }

    public final DoubleProperty maximumProperty() {
        return this.value.maxProperty();
    }

    public final void setResolution(BigDecimal val) {
        this.value.setResolution(val);
    }

    public final BigDecimal getResolution() {
        return this.value.getResolution();
    }

    public final ObjectProperty<BigDecimal> resolutionProperty() {
        return this.value.resolutionProperty();
    }

    public final void setValue(double val) {
        this.value.setValue(val);
    }

    public final double getValue() {
        return this.value.getValue();
    }

    public final DoubleProperty valueProperty() {
        return this.value.valueProperty();
    }

    private final void setValueProperty(ClampedValue value) {
        if (this.value != null) {
            this.value.removeListener(this.cvl);
        }
        this.value = value;
        this.value.addListener(this.cvl);
    }

    public final void setSliderWidth(Integer value) {
        this.sliderWidth.set(value.intValue());
    }

    public final Integer getSliderWidth() {
        return this.sliderWidth.get();
    }

    public final IntegerProperty sliderWidthProperty() {
        return this.sliderWidth;
    }

    @Override
    public final void setRandomizable(boolean value) {
        this.randomizable.set(value);
    }

    @Override
    public final boolean isRandomizable() {
        return this.randomizable.get();
    }

    public final BooleanProperty randomizableProperty() {
        return this.randomizable;
    }

    public final boolean isValueDisplayEnabled() {
        return this.valueDisplayEnabled.get();
    }

    public final void setValueDisplayEnabled(boolean enabled) {
        this.valueDisplayEnabled.set(enabled);
    }

    public final BooleanProperty valueDisplayEnabledProperty() {
        return this.valueDisplayEnabled;
    }

    public static BSBObject loadFromXML(Element data) {
        BSBHSlider slider = new BSBHSlider();
        double minVal = 0.0;
        double maxVal = 1.0;
        double val = 0.0;
        BigDecimal res = new BigDecimal("0.1");
        BSBHSlider.initBasicFromXML(data, slider);
        String verString = data.getAttributeValue("version");
        int version = verString == null ? 1 : Integer.parseInt(verString);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            String nodeText = node.getTextString();
            switch (nodeName) {
                case "minimum": {
                    minVal = Double.parseDouble(nodeText);
                    break;
                }
                case "maximum": {
                    maxVal = Double.parseDouble(nodeText);
                    break;
                }
                case "resolution": {
                    res = new BigDecimal(Double.parseDouble(nodeText)).setScale(5, RoundingMode.HALF_UP).stripTrailingZeros();
                    break;
                }
                case "bdresolution": {
                    res = new BigDecimal(nodeText);
                    break;
                }
                case "value": {
                    val = Double.parseDouble(nodeText);
                    break;
                }
                case "sliderWidth": {
                    slider.setSliderWidth(Integer.parseInt(nodeText));
                    break;
                }
                case "randomizable": {
                    slider.setRandomizable(XMLUtilities.readBoolean(node));
                    break;
                }
                case "valueDisplayEnabled": {
                    slider.setValueDisplayEnabled(XMLUtilities.readBoolean(node));
                }
            }
        }
        slider.setValueProperty(new ClampedValue(minVal, maxVal, val, res));
        return slider;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBHSlider.getBasicXML(this);
        retVal.setAttribute("version", "2");
        retVal.addElement("minimum").setText(Double.toString(this.getMinimum()));
        retVal.addElement("maximum").setText(Double.toString(this.getMaximum()));
        retVal.addElement("bdresolution").setText(this.getResolution().toString());
        retVal.addElement("value").setText(Double.toString(this.getValue()));
        retVal.addElement("sliderWidth").setText(Integer.toString(this.getSliderWidth()));
        retVal.addElement(XMLUtilities.writeBoolean("randomizable", this.isRandomizable()));
        retVal.addElement(XMLUtilities.writeBoolean("valueDisplayEnabled", this.isValueDisplayEnabled()));
        return retVal;
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        Parameter param;
        if (this.parameters != null && (param = this.parameters.getParameter(this.getObjectName())) != null && param.getCompilationVarName() != null) {
            compilationUnit.addReplacementValue(this.getObjectName(), param.getCompilationVarName());
            return;
        }
        compilationUnit.addReplacementValue(this.getObjectName(), NumberUtilities.formatDouble(this.getValue()));
    }

    @Override
    public String getPresetValue() {
        return Double.toString(this.getValue());
    }

    @Override
    public void setPresetValue(String val) {
        this.setValue(Double.parseDouble(val));
    }

    @Override
    public void initializeParameters() {
        if (this.parameters == null) {
            return;
        }
        if (!this.automationAllowed && this.getObjectName() != null && this.getObjectName().length() != 0) {
            Parameter param = this.parameters.getParameter(this.getObjectName());
            if (param != null && param.isAutomationEnabled()) {
                this.automationAllowed = true;
            } else {
                this.parameters.removeParameter(this.getObjectName());
                return;
            }
        }
        if (this.getObjectName() == null || this.getObjectName().trim().length() == 0) {
            return;
        }
        Parameter parameter = this.parameters.getParameter(this.getObjectName());
        if (parameter != null) {
            parameter.addParameterListener(this);
            if (!parameter.isAutomationEnabled()) {
                parameter.setValue(this.getValue());
            }
            return;
        }
        Parameter param = new Parameter();
        param.setValue(this.getValue());
        param.setMax(this.getMaximum(), true);
        param.setMin(this.getMinimum(), true);
        param.setName(this.getObjectName());
        param.setResolution(this.getResolution());
        param.addParameterListener(this);
        param.setValue(this.getValue());
        this.parameters.add(param);
    }

    @Override
    public void lineDataChanged(Parameter param) {
        Parameter parameter = this.parameters.getParameter(this.getObjectName());
        if (parameter != null) {
            double time = ParameterTimeManagerFactory.getInstance().getTime();
            double val = parameter.getLine().getValue(time);
            this.setValue(val);
        }
    }

    @Override
    public void parameterChanged(Parameter param) {
    }

    @Override
    public void setAutomationAllowed(boolean allowAutomation) {
        this.automationAllowed = allowAutomation;
        if (this.parameters != null) {
            if (allowAutomation) {
                this.initializeParameters();
            } else if (this.getObjectName() != null && this.getObjectName().length() != 0) {
                this.parameters.removeParameter(this.getObjectName());
            }
        }
    }

    @Override
    public void randomize() {
        if (this.isRandomizable()) {
            double newValue;
            double range = this.getMaximum() - this.getMinimum();
            if (this.getResolution().doubleValue() > 0.0) {
                BigDecimal newV = new BigDecimal(range * Math.random()).setScale(this.getResolution().scale(), RoundingMode.HALF_UP);
                newV = newV.subtract(newV.remainder(this.getResolution()));
                newValue = newV.doubleValue() + this.getMinimum();
            } else {
                newValue = Math.random() * range + this.getMinimum();
            }
            double oldValue = this.getValue();
            this.setValue(newValue);
            if (this.propListeners != null) {
                this.propListeners.firePropertyChange("updateValue", new Double(oldValue), new Double(newValue));
            }
        }
    }

    @Override
    public BSBObject deepCopy() {
        return new BSBHSlider(this);
    }

    private ClampedValue getValueProperty() {
        return this.value;
    }
}

