/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.DeepCopyable;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBObjectListener;
import blue.orchestra.blueSynthBuilder.UniqueNameManager;
import electric.xml.Element;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;

public abstract class BSBObject
implements DeepCopyable<BSBObject> {
    private StringProperty objectName;
    private IntegerProperty x;
    private IntegerProperty y;
    transient Vector listeners = null;
    transient PropertyChangeSupport propListeners = null;
    transient UniqueNameManager unm = null;

    public BSBObject() {
        this.x = new SimpleIntegerProperty(0);
        this.y = new SimpleIntegerProperty(0);
        this.objectName = new SimpleStringProperty("");
    }

    public BSBObject(BSBObject bsbObj) {
        this.x = new SimpleIntegerProperty(bsbObj.getX());
        this.y = new SimpleIntegerProperty(bsbObj.getY());
        this.objectName = new SimpleStringProperty(bsbObj.getObjectName());
    }

    public String getObjectName() {
        return (String)this.objectName.get();
    }

    public void setObjectName(String objectName) {
        String oldName = (String)this.objectName.get();
        if (oldName == objectName || oldName.equals(objectName)) {
            return;
        }
        if (this.unm != null && objectName != null && objectName.length() != 0 && !this.unm.isUnique(objectName)) {
            return;
        }
        this.objectName.set((Object)objectName);
    }

    public StringProperty objectNameProperty() {
        return this.objectName;
    }

    public final void setX(int value) {
        this.x.set(value);
    }

    public final int getX() {
        return this.x.get();
    }

    public final IntegerProperty xProperty() {
        return this.x;
    }

    public final void setY(int value) {
        this.y.set(value);
    }

    public final int getY() {
        return this.y.get();
    }

    public final IntegerProperty yProperty() {
        return this.y;
    }

    public String[] getReplacementKeys() {
        String name = this.getObjectName();
        if (name == null || name.trim().length() == 0) {
            return new String[0];
        }
        return new String[]{name};
    }

    public abstract Element saveAsXML();

    public abstract void setupForCompilation(BSBCompilationUnit var1);

    public static void initBasicFromXML(Element data, BSBObject bsbObj) {
        String name = data.getTextString("objectName");
        name = name == null ? "" : name;
        bsbObj.objectName.set((Object)name);
        bsbObj.setX(Integer.parseInt(data.getTextString("x")));
        bsbObj.setY(Integer.parseInt(data.getTextString("y")));
    }

    public static Element getBasicXML(BSBObject bsbObj) {
        Element retVal = new Element("bsbObject");
        retVal.setAttribute("type", bsbObj.getClass().getName());
        retVal.addElement("objectName").setText(bsbObj.getObjectName());
        retVal.addElement("x").setText(Integer.toString(bsbObj.getX()));
        retVal.addElement("y").setText(Integer.toString(bsbObj.getY()));
        return retVal;
    }

    public abstract String getPresetValue();

    public abstract void setPresetValue(String var1);

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public void addListener(BSBObjectListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    public void removeListener(BSBObjectListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireBSBObjectChanged() {
        if (this.listeners != null) {
            for (BSBObjectListener currListener : this.listeners) {
                currListener.bsbObjectChanged(this);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propListeners == null) {
            this.propListeners = new PropertyChangeSupport(this);
        }
        this.propListeners.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propListeners != null) {
            this.propListeners.removePropertyChangeListener(pcl);
        }
    }

    public void setUniqueNameManager(UniqueNameManager unm) {
        this.unm = unm;
    }
}

