/*
 * Decompiled with CFR 0.152.
 */
package blue.scripting;

import blue.BlueSystem;
import blue.scripting.ScoreScriptEngine;
import blue.utilities.ProcessRunner;
import blue.utility.FileUtilities;
import blue.utility.TextUtilities;
import java.io.File;
import java.util.Map;
import javax.script.ScriptException;

public class ExternalScoreEngine
implements ScoreScriptEngine {
    @Override
    public String getEngineName() {
        return "External";
    }

    @Override
    public String evalCode(String code, Map<String, Object> initValues) throws ScriptException {
        ProcessRunner processRunner = new ProcessRunner();
        File currentWorkingDirectory = null;
        try {
            File temp = FileUtilities.createTempTextFile("blueTempText", ".txt", BlueSystem.getCurrentProjectDirectory(), code);
            StringBuilder buffer = new StringBuilder();
            String commandLine = (String)initValues.get("commandline");
            currentWorkingDirectory = temp.getParentFile();
            if (!commandLine.contains("$outfile")) {
                commandLine = ExternalScoreEngine.getPreparedCommandLine(commandLine, temp.getName());
                System.out.println("Calling command: " + commandLine);
                System.out.println("Using directory: " + currentWorkingDirectory.getAbsolutePath());
                processRunner.execWaitAndCollect(commandLine, currentWorkingDirectory);
                buffer.append(processRunner.getCollectedOutput());
            } else {
                File outFile = File.createTempFile("blueTempOutFile", ".sco", BlueSystem.getCurrentProjectDirectory());
                outFile.deleteOnExit();
                commandLine = ExternalScoreEngine.getPreparedCommandLine(commandLine, temp.getName(), outFile.getName());
                System.out.println("Calling command: " + commandLine);
                System.out.println("Using directory: " + currentWorkingDirectory.getAbsolutePath());
                processRunner.execWait(commandLine, currentWorkingDirectory);
                buffer.append(TextUtilities.getTextFromFile(outFile));
            }
            return buffer.toString();
        }
        catch (Exception ex) {
            throw new ScriptException(ex);
        }
    }

    protected static String getPreparedCommandLine(String commandLine, String inFileName, String outFileName) {
        String temp = ExternalScoreEngine.getPreparedCommandLine(commandLine, inFileName);
        return TextUtilities.replace(temp, "$outfile", outFileName);
    }

    protected static String getPreparedCommandLine(String commandLine, String inFileName) {
        if (!commandLine.contains("$infile")) {
            return commandLine + " " + inFileName;
        }
        return TextUtilities.replace(commandLine, "$infile", inFileName);
    }
}

