/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.score.ScoreObjectEvent;
import blue.score.ScoreObjectListener;
import blue.soundObject.SoundObject;
import java.awt.Color;
import java.util.Vector;

public abstract class AbstractSoundObject
implements SoundObject {
    protected double subjectiveDuration = 2.0;
    protected double startTime = 0.0;
    protected String name = "";
    protected Color backgroundColor = Color.DARK_GRAY;
    transient Vector<ScoreObjectListener> soundObjectListeners = null;

    public AbstractSoundObject() {
    }

    public AbstractSoundObject(AbstractSoundObject aso) {
        this.subjectiveDuration = aso.subjectiveDuration;
        this.startTime = aso.startTime;
        this.name = aso.name;
        this.backgroundColor = aso.backgroundColor;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 0);
        this.fireScoreObjectEvent(event);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setStartTime(double startTime) {
        this.startTime = startTime;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 1);
        this.fireScoreObjectEvent(event);
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public void setSubjectiveDuration(double subjectiveDuration) {
        this.subjectiveDuration = subjectiveDuration;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 2);
        this.fireScoreObjectEvent(event);
    }

    @Override
    public double getSubjectiveDuration() {
        return this.subjectiveDuration;
    }

    @Override
    public double getMaxResizeRightDiff() {
        return Double.MAX_VALUE;
    }

    @Override
    public double getMaxResizeLeftDiff() {
        return -this.getStartTime();
    }

    @Override
    public void resizeLeft(double newStartTime) {
        double diff = this.startTime - newStartTime;
        this.setStartTime(newStartTime);
        this.setSubjectiveDuration(this.subjectiveDuration + diff);
    }

    @Override
    public void resizeRight(double newEndTime) {
        this.setSubjectiveDuration(newEndTime - this.startTime);
    }

    @Override
    public void addScoreObjectListener(ScoreObjectListener listener) {
        if (this.soundObjectListeners == null) {
            this.soundObjectListeners = new Vector();
        }
        this.soundObjectListeners.add(listener);
    }

    @Override
    public void removeScoreObjectListener(ScoreObjectListener listener) {
        if (this.soundObjectListeners == null) {
            return;
        }
        this.soundObjectListeners.remove(listener);
    }

    public void fireScoreObjectEvent(ScoreObjectEvent sObjEvent) {
        if (this.soundObjectListeners == null) {
            return;
        }
        for (ScoreObjectListener listener : this.soundObjectListeners) {
            listener.scoreObjectChanged(sObjEvent);
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 3);
        this.fireScoreObjectEvent(event);
    }
}

