/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.BlueSystem;
import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.orchestra.GenericInstrument;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.ObjectUtilities;
import electric.xml.Element;
import java.util.Map;

public class FrozenSoundObject
extends AbstractSoundObject {
    private static final String FSO_INSTR_NAME = "Frozen SoundObject Player Instrument";
    private static final String FSO_HAS_BEEN_COMPILED = "frozenSoundObject.hasBeenCompiled";
    private SoundObject frozenSoundObject;
    private String frozenWaveFileName;
    private int numChannels = 0;
    private static transient int instrumentNumber;

    public FrozenSoundObject() {
    }

    public FrozenSoundObject(FrozenSoundObject fso) {
        this.frozenSoundObject = fso.frozenSoundObject.deepCopy();
        this.frozenWaveFileName = fso.frozenWaveFileName;
        this.numChannels = fso.numChannels;
    }

    @Override
    public double getObjectiveDuration() {
        return this.subjectiveDuration;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return null;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain chain) {
    }

    @Override
    public int getTimeBehavior() {
        return -1;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
    }

    @Override
    public double getRepeatPoint() {
        return -1.0;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
    }

    public SoundObject getFrozenSoundObject() {
        return this.frozenSoundObject;
    }

    public void setFrozenSoundObject(SoundObject frozenSoundObject) {
        this.frozenSoundObject = frozenSoundObject;
    }

    public String getFrozenWaveFileName() {
        return this.frozenWaveFileName;
    }

    public void setFrozenWaveFileName(String frozenWaveFileName) {
        this.frozenWaveFileName = frozenWaveFileName;
    }

    public NoteList generateNotes(double renderStart, double renderEnd) throws SoundObjectException {
        NoteList n = new NoteList();
        if (instrumentNumber == 0) {
            return n;
        }
        double newDur = this.subjectiveDuration;
        if (renderEnd > 0.0 && renderEnd < this.subjectiveDuration) {
            newDur = renderEnd;
        }
        newDur -= renderStart;
        StringBuilder buffer = new StringBuilder();
        buffer.append("i").append(instrumentNumber);
        buffer.append("\t").append(this.startTime + renderStart);
        buffer.append("\t").append(newDur);
        buffer.append("\t\"").append(this.getFrozenWaveFileName()).append("\"");
        buffer.append("\t").append(renderStart);
        Note tempNote = null;
        try {
            tempNote = Note.createNote(buffer.toString());
        }
        catch (NoteParseException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        if (tempNote != null) {
            n.add(tempNote);
        }
        return n;
    }

    public void generateInstruments(CompileData compileData) {
        Object obj = compileData.getCompilationVariable(FSO_HAS_BEEN_COMPILED);
        if (obj == null || obj != Boolean.TRUE) {
            int iNum;
            compileData.setCompilationVariable(FSO_HAS_BEEN_COMPILED, Boolean.TRUE);
            String instrumentText = this.generateInstrumentText();
            if (instrumentText == null) {
                throw new RuntimeException(new SoundObjectException((SoundObject)this, BlueSystem.getString("audioFile.couldNotGenerate") + " " + this.getName()));
            }
            GenericInstrument temp = new GenericInstrument();
            temp.setName(FSO_INSTR_NAME);
            temp.setText(instrumentText);
            instrumentNumber = iNum = compileData.addInstrument(temp);
        }
    }

    private String generateInstrumentText() {
        StringBuilder iText = new StringBuilder();
        String channelVariables = this.getChannelVariables();
        if (channelVariables == null) {
            return null;
        }
        iText.append(channelVariables).append("\tdiskin2\tp4, 1, p5\n");
        if (this.numChannels == 1) {
            iText.append("\tout\t").append(channelVariables);
        } else {
            iText.append("\toutc\t").append(channelVariables);
        }
        return iText.toString();
    }

    private String getChannelVariables() {
        if (this.numChannels <= 0) {
            return null;
        }
        String info = "aChannel1";
        int i = 1;
        while (i < this.numChannels) {
            info = info + ", aChannel" + ++i;
        }
        return info;
    }

    public static void main(String[] args) {
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public void setNumChannels(int i) {
        this.numChannels = i;
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        FrozenSoundObject fso = new FrozenSoundObject();
        SoundObjectUtilities.initBasicFromXML(data, fso);
        fso.setNumChannels(Integer.parseInt(data.getElement("numChannels").getTextString()));
        fso.setFrozenWaveFileName(data.getElement("frozenWaveFileName").getTextString());
        fso.setFrozenSoundObject((SoundObject)ObjectUtilities.loadFromXML(data.getElement("soundObject"), objRefMap));
        return fso;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement("numChannels").setText(Integer.toString(this.getNumChannels()));
        retVal.addElement("frozenWaveFileName").setText(this.getFrozenWaveFileName());
        retVal.addElement(this.getFrozenSoundObject().saveAsXML(objRefMap));
        return retVal;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        this.generateInstruments(compileData);
        NoteList nl = this.generateNotes(startTime, endTime);
        return nl;
    }

    @Override
    public FrozenSoundObject deepCopy() {
        return new FrozenSoundObject(this);
    }
}

