/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.BlueSystem;
import blue.soundObject.NoteParseException;
import blue.utility.NumberUtilities;
import blue.utility.ScoreExpressionParser;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.StrBuilder;

public class Note
implements Comparable<Note> {
    private static final Pattern p = Pattern.compile("\"[^\"]*\"|\\[[^\\]]*\\]|\\S*", 4);
    private String[] fields;
    private double subjectiveDuration;
    boolean isTied = false;

    private Note() {
    }

    public Note(Note note) {
        this.subjectiveDuration = note.subjectiveDuration;
        this.fields = (String[])note.fields.clone();
        this.isTied = note.isTied;
    }

    public static Note createNote(int numFields) {
        Note n = new Note();
        n.fields = new String[numFields];
        for (int i = 0; i < numFields; ++i) {
            n.setPField(Integer.toString(i), i + 1);
        }
        return n;
    }

    public static Note createNote(String input) throws NoteParseException {
        return Note.createNote(input, null);
    }

    public static Note createNote(String input, Note previousNote) throws NoteParseException {
        if (!input.startsWith("i")) {
            String errorMessage = BlueSystem.getString("note.invalidNoteText") + " " + input;
            throw new NoteParseException(errorMessage, input);
        }
        try {
            Note n = new Note();
            String cleanNoteString = input.substring(input.indexOf(105) + 1);
            n.noteInit(cleanNoteString, previousNote);
            return n;
        }
        catch (Exception e) {
            String errorMessage = BlueSystem.getString("note.invalidNoteText") + " " + input;
            e.printStackTrace();
            throw new NoteParseException(errorMessage, input);
        }
    }

    private void noteInit(String input, Note previousNote) throws Exception {
        int i = 0;
        ArrayList<String> buffer = new ArrayList<String>();
        int size = input.length();
        boolean start = false;
        Matcher m = p.matcher(input);
        while (m.find()) {
            String str = m.group();
            if (str.isEmpty()) continue;
            if (str.charAt(0) == '[') {
                str = Double.toString(ScoreExpressionParser.eval(str.substring(1, str.length() - 1)));
            }
            buffer.add(str);
        }
        if (previousNote != null) {
            int numFieldsToCopy;
            boolean performCarry = ((String)buffer.get(0)).equals(previousNote.getPField(1));
            if (!performCarry) {
                try {
                    int instr1 = (int)Double.parseDouble((String)buffer.get(0));
                    int instr2 = (int)Double.parseDouble(previousNote.getPField(1));
                    if (instr1 == instr2) {
                        performCarry = true;
                    }
                }
                catch (NumberFormatException nfe) {
                    performCarry = false;
                }
            }
            if (performCarry && (numFieldsToCopy = previousNote.getPCount() - buffer.size()) > 0) {
                for (i = previousNote.getPCount() - numFieldsToCopy; i < previousNote.getPCount(); ++i) {
                    buffer.add(previousNote.getPField(i + 1));
                }
            }
        }
        this.fields = buffer.toArray(new String[buffer.size()]);
        if (previousNote != null) {
            for (i = 0; i < this.fields.length; ++i) {
                if (!this.fields[i].equals(".")) continue;
                this.fields[i] = previousNote.getPField(i + 1);
            }
        }
        double dur = Double.parseDouble(this.fields[2]);
        this.setSubjectiveDuration(dur);
        this.setTied(dur < 0.0);
    }

    public String toString() {
        StrBuilder temp = new StrBuilder();
        int strSize = 1;
        for (int i = 0; i < this.fields.length; ++i) {
            strSize += this.fields[i].length() + 1;
        }
        temp.ensureCapacity(strSize);
        temp.append("i");
        int size = this.fields.length;
        for (int i = 0; i < size; ++i) {
            if (i == 2) {
                if (this.isTied) {
                    temp.append("-");
                }
                temp.append(NumberUtilities.formatDouble(this.subjectiveDuration)).append("\t");
                continue;
            }
            temp.append(this.fields[i]);
            if (i >= size - 1) continue;
            temp.append("\t");
        }
        return temp.toString();
    }

    public void setStartTime(double start) {
        this.fields[1] = Double.toString(start);
    }

    public double getStartTime() {
        return Double.parseDouble(this.fields[1]);
    }

    public void setSubjectiveDuration(double dur) {
        this.subjectiveDuration = Math.abs(dur);
    }

    public double getSubjectiveDuration() {
        return this.subjectiveDuration;
    }

    public double getObjectiveDuration() {
        return this.getSubjectiveDuration();
    }

    public int getPCount() {
        return this.fields.length;
    }

    public String getPField(int i) {
        return this.fields[i - 1];
    }

    public void setPField(String arg, int index) {
        if (index == 3) {
            this.setSubjectiveDuration(Double.parseDouble(arg));
        }
        this.fields[index - 1] = arg;
    }

    @Override
    public int compareTo(Note b) {
        double t2;
        double t1 = this.getStartTime();
        if (t1 > (t2 = b.getStartTime())) {
            return 1;
        }
        if (t1 < t2) {
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        try {
            Note testNote = Note.createNote("i1 2 3 4 5");
            testNote.setSubjectiveDuration(12.0);
            System.out.println(testNote.toString());
            testNote = Note.createNote("i1 [4 + 23] 5 4");
            testNote.setSubjectiveDuration(12.0);
            System.out.println(testNote.toString());
            testNote = Note.createNote("i1 [4 + 23 -] 5 4");
            testNote.setSubjectiveDuration(12.0);
            System.out.println(testNote.toString());
        }
        catch (NoteParseException e) {
            e.printStackTrace();
        }
    }

    public boolean isTied() {
        return this.isTied;
    }

    public void setTied(boolean isTied) {
        this.isTied = isTied;
    }

    public double getEndTime() {
        return this.getStartTime() + this.getSubjectiveDuration();
    }
}

