/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.BlueSystem;
import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.PresetGroup;
import blue.score.ScoreObjectEvent;
import blue.scripting.ScoreScriptEngine;
import blue.scripting.ScoreScriptEngineManager;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.ScoreUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.script.ScriptException;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class ObjectBuilder
extends AbstractSoundObject {
    BSBGraphicInterface graphicInterface;
    PresetGroup presetGroup;
    String code;
    String commandLine;
    private boolean editEnabled = true;
    private NoteProcessorChain npc = new NoteProcessorChain();
    private int timeBehavior;
    double repeatPoint = -1.0;
    StringProperty comment;
    ObjectProperty<LanguageType> languageType;

    public ObjectBuilder() {
        this.setName("ObjectBuilder");
        this.graphicInterface = new BSBGraphicInterface();
        this.presetGroup = new PresetGroup();
        this.code = "";
        this.commandLine = "";
        this.timeBehavior = 0;
        this.comment = new SimpleStringProperty("");
        this.languageType = new SimpleObjectProperty((Object)LanguageType.PYTHON);
    }

    public ObjectBuilder(ObjectBuilder objBuilder) {
        super(objBuilder);
        this.graphicInterface = new BSBGraphicInterface(objBuilder.graphicInterface);
        this.presetGroup = new PresetGroup(objBuilder.presetGroup);
        this.code = objBuilder.code;
        this.commandLine = objBuilder.commandLine;
        this.timeBehavior = objBuilder.timeBehavior;
        this.editEnabled = objBuilder.editEnabled;
        this.repeatPoint = objBuilder.repeatPoint;
        this.npc = new NoteProcessorChain(objBuilder.npc);
        this.comment = new SimpleStringProperty(objBuilder.getComment());
        this.languageType = new SimpleObjectProperty((Object)objBuilder.getLanguageType());
    }

    public NoteList generateNotes(BSBCompilationUnit bsbCompilationUnit, double renderStart, double renderEnd) throws SoundObjectException {
        NoteList nl;
        String codeToRun = bsbCompilationUnit.replaceBSBValues(this.code);
        String tempScore = null;
        HashMap<String, Object> initVals = new HashMap<String, Object>();
        File currentDirFile = BlueSystem.getCurrentProjectDirectory();
        initVals.put("score", "");
        initVals.put("blueDuration", this.getSubjectiveDuration());
        initVals.put("commandline", this.commandLine);
        initVals.put("blueProjectDir", currentDirFile);
        ScoreScriptEngine engine = ScoreScriptEngineManager.getInstance().getEngine(this.getLanguageType().toString());
        try {
            tempScore = engine.evalCode(codeToRun, initVals);
        }
        catch (ScriptException ex) {
            if (this.getLanguageType() == LanguageType.EXTERNAL) {
                throw new SoundObjectException(this, this.getIOExceptionMessage(), ex);
            }
            throw new SoundObjectException((SoundObject)this, (Throwable)ex);
        }
        try {
            nl = ScoreUtilities.getNotes(tempScore);
        }
        catch (NoteParseException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        try {
            ScoreUtilities.applyNoteProcessorChain(nl, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        ScoreUtilities.applyTimeBehavior(nl, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint());
        ScoreUtilities.setScoreStart(nl, this.startTime);
        return nl;
    }

    private String getIOExceptionMessage() {
        System.out.println("[Error] Score Generation failed in ObjectBuilder soundObject labeled " + this.getName());
        String errorMessage = "ObjectBuilder SoundObject Score Generation Error";
        errorMessage = errorMessage + "\n\nUnable to execute the command: " + this.commandLine;
        errorMessage = errorMessage + "\n\nPlease check that the command is either in your path\n";
        errorMessage = errorMessage + "or that the absolute path specified is correct.";
        return errorMessage;
    }

    @Override
    public double getObjectiveDuration() {
        return this.getSubjectiveDuration();
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain noteProcessorChain) {
        this.npc = noteProcessorChain;
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 4);
        this.fireScoreObjectEvent(event);
    }

    public final void setComment(String value) {
        this.comment.set((Object)value);
    }

    public final String getComment() {
        return (String)this.comment.get();
    }

    public final StringProperty commentProperty() {
        return this.comment;
    }

    public final void setLanguageType(LanguageType value) {
        this.languageType.set((Object)value);
    }

    public final LanguageType getLanguageType() {
        return (LanguageType)((Object)this.languageType.get());
    }

    public final ObjectProperty<LanguageType> languageTypeProperty() {
        return this.languageType;
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        ObjectBuilder bsb = new ObjectBuilder();
        SoundObjectUtilities.initBasicFromXML(data, bsb);
        String editEnabledStr = data.getAttributeValue("editEnabled");
        if (editEnabledStr != null) {
            bsb.setEditEnabled(Boolean.valueOf(editEnabledStr));
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "code": {
                    bsb.setCode(node.getTextString());
                    break;
                }
                case "commandLine": {
                    bsb.setCommandLine(node.getTextString());
                    break;
                }
                case "isExternal": {
                    if (XMLUtilities.readBoolean(node)) {
                        bsb.setLanguageType(LanguageType.EXTERNAL);
                        break;
                    }
                    bsb.setLanguageType(LanguageType.PYTHON);
                    break;
                }
                case "graphicInterface": {
                    bsb.setGraphicInterface(BSBGraphicInterface.loadFromXML(node));
                    break;
                }
                case "presetGroup": {
                    bsb.setPresetGroup(PresetGroup.loadFromXML(node));
                    break;
                }
                case "comment": {
                    bsb.setComment(node.getTextString());
                    break;
                }
                case "languageType": {
                    bsb.setLanguageType(LanguageType.valueOf(node.getTextString()));
                }
            }
        }
        return bsb;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.setAttribute("editEnabled", Boolean.toString(this.editEnabled));
        retVal.addElement("code").setText(this.getCode());
        retVal.addElement("commandLine").setText(this.getCommandLine());
        retVal.addElement(this.graphicInterface.saveAsXML());
        retVal.addElement(this.presetGroup.saveAsXML());
        retVal.addElement("comment").setText(this.getComment());
        retVal.addElement("languageType").setText(this.getLanguageType().name());
        return retVal;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code == null ? "" : code;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public BSBGraphicInterface getGraphicInterface() {
        return this.graphicInterface;
    }

    public void setGraphicInterface(BSBGraphicInterface graphicInterface) {
        this.graphicInterface = graphicInterface;
    }

    public PresetGroup getPresetGroup() {
        return this.presetGroup;
    }

    public void setPresetGroup(PresetGroup presetGroup) {
        this.presetGroup = presetGroup;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public boolean isEditEnabled() {
        return this.editEnabled;
    }

    public void setEditEnabled(boolean editEnabled) {
        this.editEnabled = editEnabled;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        BSBCompilationUnit bsbCompilationUnit = new BSBCompilationUnit();
        this.graphicInterface.setupForCompilation(bsbCompilationUnit);
        NoteList nl = this.generateNotes(bsbCompilationUnit, startTime, endTime);
        return nl;
    }

    @Override
    public ObjectBuilder deepCopy() {
        return new ObjectBuilder(this);
    }

    public static enum LanguageType {
        PYTHON("Python", "text/x-python"),
        JAVASCRIPT("JavaScript", "text/javascript"),
        CLOJURE("Clojure", "text/x-clojure"),
        EXTERNAL("External", "text/plain");

        private String desc;
        private String mimeType;

        private LanguageType(String desc, String mimeType) {
            this.desc = desc;
            this.mimeType = mimeType;
        }

        public String toString() {
            return this.desc;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }
}

