/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreObjectEvent;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.GenericViewable;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.soundObject.pattern.Pattern;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class PatternObject
extends AbstractSoundObject
implements TableModel,
GenericViewable {
    private NoteProcessorChain npc = new NoteProcessorChain();
    private int timeBehavior;
    double repeatPoint = -1.0;
    private int beats = 4;
    private int subDivisions = 4;
    private transient Vector listeners = null;
    private transient Vector pListeners = null;
    private ArrayList<Pattern> patterns = new ArrayList();

    public PatternObject() {
        this.setName("Pattern");
        this.timeBehavior = 0;
    }

    public PatternObject(PatternObject pObj) {
        super(pObj);
        this.npc = new NoteProcessorChain(pObj.npc);
        this.timeBehavior = pObj.timeBehavior;
        this.repeatPoint = pObj.repeatPoint;
        this.beats = pObj.beats;
        this.subDivisions = pObj.subDivisions;
        for (Pattern p : pObj.patterns) {
            this.patterns.add(new Pattern(p));
        }
    }

    public void addPattern(int index) {
        Pattern pattern = new Pattern(this.beats * this.subDivisions);
        pattern.setPatternName(pattern.getPatternName() + this.patterns.size());
        this.patterns.add(index, pattern);
        this.fireTableDataChanged();
    }

    private void addPattern(Pattern p) {
        this.patterns.add(p);
    }

    public void removePattern(int index) {
        this.patterns.remove(index);
        this.fireTableDataChanged();
    }

    public void pushUpPatternLayers(int[] rows) {
        Pattern a = this.patterns.remove(rows[0] - 1);
        this.patterns.add(rows[rows.length - 1], a);
        this.fireTableDataChanged();
    }

    public void pushDownPatternLayers(int[] rows) {
        Pattern a = this.patterns.remove(rows[rows.length - 1] + 1);
        this.patterns.add(rows[0], a);
        this.fireTableDataChanged();
    }

    public int size() {
        return this.patterns.size();
    }

    public Pattern getPattern(int index) {
        return this.patterns.get(index);
    }

    public NoteList generateNotes(double renderStart, double renderEnd) throws SoundObjectException {
        double start;
        NoteList tempPattern;
        int j;
        boolean[] tempPatternArray;
        Pattern p;
        int i;
        NoteList tempNoteList = new NoteList();
        boolean soloFound = false;
        double timeIncrement = 1.0f / (float)this.subDivisions;
        for (i = 0; i < this.size(); ++i) {
            p = this.getPattern(i);
            if (!p.isSolo() || p.isMuted()) continue;
            soloFound = true;
            tempPatternArray = p.values;
            for (j = 0; j < tempPatternArray.length; ++j) {
                if (!tempPatternArray[j]) continue;
                try {
                    tempPattern = ScoreUtilities.getNotes(p.getPatternScore());
                }
                catch (NoteParseException e) {
                    throw new SoundObjectException((SoundObject)this, (Throwable)e);
                }
                start = (double)j * timeIncrement;
                ScoreUtilities.setScoreStart(tempPattern, start);
                tempNoteList.merge(tempPattern);
            }
        }
        if (!soloFound) {
            for (i = 0; i < this.size(); ++i) {
                p = this.getPattern(i);
                if (p.isMuted()) continue;
                tempPatternArray = p.values;
                for (j = 0; j < tempPatternArray.length; ++j) {
                    if (!tempPatternArray[j]) continue;
                    try {
                        tempPattern = ScoreUtilities.getNotes(p.getPatternScore());
                    }
                    catch (NoteParseException e) {
                        throw new SoundObjectException((SoundObject)this, (Throwable)e);
                    }
                    start = (double)j * timeIncrement;
                    ScoreUtilities.setScoreStart(tempPattern, start);
                    tempNoteList.merge(tempPattern);
                }
            }
        }
        try {
            ScoreUtilities.applyNoteProcessorChain(tempNoteList, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        ScoreUtilities.applyTimeBehavior(tempNoteList, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint(), this.beats);
        ScoreUtilities.setScoreStart(tempNoteList, this.startTime);
        return tempNoteList;
    }

    @Override
    public double getObjectiveDuration() {
        return this.getSubjectiveDuration();
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 4);
        this.fireScoreObjectEvent(event);
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain chain) {
        this.npc = chain;
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        PatternObject pattern = new PatternObject();
        SoundObjectUtilities.initBasicFromXML(data, pattern);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "beats": {
                    pattern.setBeats(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "subDivisions": {
                    pattern.setSubDivisions(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "patterns": {
                    Elements patternNodes = node.getElements();
                    while (patternNodes.hasMoreElements()) {
                        Pattern p = Pattern.loadFromXML(patternNodes.next());
                        pattern.addPattern(p);
                    }
                    break;
                }
            }
        }
        return pattern;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement("beats").setText(Integer.toString(this.beats));
        retVal.addElement("subDivisions").setText(Integer.toString(this.subDivisions));
        Element patternsNode = new Element("patterns");
        retVal.addElement(patternsNode);
        for (Pattern element : this.patterns) {
            patternsNode.addElement(element.saveAsXML());
        }
        return retVal;
    }

    public int getBeats() {
        return this.beats;
    }

    public void setBeats(int bars) {
        this.beats = bars;
    }

    public int getSubDivisions() {
        return this.subDivisions;
    }

    public void setSubDivisions(int subDivisions) {
        this.subDivisions = subDivisions;
    }

    public void setTime(int beats, int subDivisions) {
        if (this.beats == beats && this.subDivisions == subDivisions) {
            return;
        }
        this.beats = beats;
        this.subDivisions = subDivisions;
        int numBeats = beats * subDivisions;
        for (Pattern p : this.patterns) {
            p.values = new boolean[numBeats];
            for (int i = 0; i < p.values.length; ++i) {
                p.values[i] = false;
            }
        }
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "time", null, null);
        this.firePropertyChangeEvent(pce);
    }

    @Override
    public int getRowCount() {
        return this.patterns.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Pattern Name";
            }
            case 1: {
                return "[x]";
            }
        }
        return "Error";
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pattern p = this.patterns.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return p.getPatternName();
            }
            case 1: {
                return p.isMuted();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Pattern p = this.patterns.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                p.setPatternName(aValue.toString());
                break;
            }
            case 1: {
                p.setMuted((Boolean)aValue);
                break;
            }
            default: {
                throw new RuntimeException("Error: columnIndex " + columnIndex + " not supported");
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    private void fireTableDataChanged() {
        if (this.listeners == null) {
            return;
        }
        TableModelEvent tme = new TableModelEvent(this);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(tme);
        }
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.pListeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.pListeners) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.pListeners == null) {
            this.pListeners = new Vector();
        }
        this.pListeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.pListeners == null) {
            return;
        }
        this.pListeners.remove(pcl);
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        return this.generateNotes(startTime, endTime);
    }

    @Override
    public PatternObject deepCopy() {
        return new PatternObject(this);
    }
}

