/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.BlueSystem;
import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreObjectEvent;
import blue.scripting.PythonProxy;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.OnLoadProcessable;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import java.util.Map;
import org.python.core.PyException;

public class PythonObject
extends AbstractSoundObject
implements OnLoadProcessable {
    private NoteProcessorChain npc = new NoteProcessorChain();
    private int timeBehavior;
    double repeatPoint = -1.0;
    private String pythonCode;
    private boolean onLoadProcessable = false;

    public PythonObject() {
        this.setName("PythonObject");
        this.pythonCode = BlueSystem.getString("pythonObject.defaultCode");
        this.pythonCode = this.pythonCode + "\n\nscore = \"i1 0 2 3 4 5\"";
        this.timeBehavior = 0;
    }

    public PythonObject(PythonObject pObj) {
        super(pObj);
        this.npc = new NoteProcessorChain(pObj.npc);
        this.timeBehavior = pObj.timeBehavior;
        this.repeatPoint = pObj.repeatPoint;
        this.pythonCode = pObj.pythonCode;
        this.onLoadProcessable = pObj.onLoadProcessable;
    }

    public void setText(String text) {
        this.pythonCode = text;
    }

    public String getText() {
        return this.pythonCode;
    }

    @Override
    public double getObjectiveDuration() {
        return this.subjectiveDuration;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain chain) {
        this.npc = chain;
    }

    public final NoteList generateNotes(double renderStart, double renderEnd) throws SoundObjectException {
        NoteList nl;
        String tempScore = null;
        try {
            tempScore = PythonProxy.processPythonScore(this.pythonCode, this.subjectiveDuration);
        }
        catch (PyException pyEx) {
            String msg = "Jython Error:\n" + pyEx.toString();
            throw new SoundObjectException((SoundObject)this, msg);
        }
        try {
            nl = ScoreUtilities.getNotes(tempScore);
        }
        catch (NoteParseException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        try {
            ScoreUtilities.applyNoteProcessorChain(nl, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        ScoreUtilities.applyTimeBehavior(nl, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint());
        ScoreUtilities.setScoreStart(nl, this.startTime);
        return nl;
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 4);
        this.fireScoreObjectEvent(event);
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        PythonObject pObj = new PythonObject();
        SoundObjectUtilities.initBasicFromXML(data, pObj);
        pObj.setText(data.getTextString("pythonCode"));
        String olpString = data.getAttributeValue("onLoadProcessable");
        if (olpString != null) {
            pObj.setOnLoadProcessable(Boolean.valueOf(olpString));
        }
        return pObj;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement("pythonCode").setText(this.getText());
        retVal.setAttribute("onLoadProcessable", Boolean.toString(this.onLoadProcessable));
        return retVal;
    }

    @Override
    public void setOnLoadProcessable(boolean onLoadProcessable) {
        this.onLoadProcessable = onLoadProcessable;
    }

    @Override
    public boolean isOnLoadProcessable() {
        return this.onLoadProcessable;
    }

    @Override
    public void processOnLoad() throws SoundObjectException {
        if (this.onLoadProcessable) {
            this.generateNotes(0.0, -1.0);
        }
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        return this.generateNotes(startTime, endTime);
    }

    @Override
    public PythonObject deepCopy() {
        return new PythonObject(this);
    }
}

