/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.automation.Parameter;
import blue.automation.ParameterList;
import blue.components.lines.Line;
import blue.components.lines.SoundObjectParameterLine;
import blue.noteProcessor.NoteProcessorChain;
import blue.orchestra.BlueSynthBuilder;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;

public class Sound
extends AbstractSoundObject {
    BlueSynthBuilder bsbObj;
    StringProperty comment;
    ListChangeListener<? super Parameter> paramListListener = e -> {
        while (e.next()) {
            for (Parameter param : e.getAddedSubList()) {
                this.adjustLineType(param);
            }
        }
    };

    public Sound() {
        this.setName("Sound");
        this.comment = new SimpleStringProperty("");
        this.setBlueSynthBuilder(new BlueSynthBuilder());
    }

    public Sound(Sound sound) {
        super(sound);
        this.comment = new SimpleStringProperty(sound.getComment());
        this.setBlueSynthBuilder(new BlueSynthBuilder(sound.bsbObj));
    }

    protected void adjustLineType(Parameter param) {
        Line line = param.getLine();
        if (!(line instanceof SoundObjectParameterLine)) {
            SoundObjectParameterLine soundObjectParameterLine = new SoundObjectParameterLine(this, line);
            param.setLine(soundObjectParameterLine);
        }
    }

    @Override
    public double getObjectiveDuration() {
        return this.subjectiveDuration;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return null;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain chain) {
    }

    public BlueSynthBuilder getBlueSynthBuilder() {
        return this.bsbObj;
    }

    public void setBlueSynthBuilder(BlueSynthBuilder bsbObj) {
        ParameterList paramList;
        if (this.bsbObj != null) {
            paramList = bsbObj.getParameterList();
            paramList.removeListener(this.paramListListener);
        }
        paramList = bsbObj.getParameterList();
        Iterator iterator = paramList.iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            this.adjustLineType(param);
        }
        paramList.addListener(this.paramListListener);
        this.bsbObj = bsbObj;
    }

    public final void setComment(String value) {
        this.comment.set((Object)value);
    }

    public final String getComment() {
        return (String)this.comment.get();
    }

    public final StringProperty commentProperty() {
        return this.comment;
    }

    public NoteList generateNotes(int instrumentNumber, double renderStart, double renderEnd) throws SoundObjectException {
        NoteList n = new NoteList();
        String noteText = "i" + instrumentNumber + "\t" + this.startTime + "\t" + this.subjectiveDuration;
        Note tempNote = null;
        try {
            tempNote = Note.createNote(noteText);
        }
        catch (NoteParseException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        if (tempNote != null) {
            n.add(tempNote);
        }
        return n;
    }

    @Override
    public int getTimeBehavior() {
        return -1;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
    }

    @Override
    public double getRepeatPoint() {
        return -1.0;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        Sound sObj = new Sound();
        SoundObjectUtilities.initBasicFromXML(data, sObj);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "instrumentText": {
                    sObj.bsbObj.setInstrumentText(node.getTextString());
                    break;
                }
                case "instrument": {
                    sObj.setBlueSynthBuilder((BlueSynthBuilder)BlueSynthBuilder.loadFromXML(node));
                    break;
                }
                case "comment": {
                    sObj.setComment(node.getTextString());
                }
            }
        }
        return sObj;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement(this.bsbObj.saveAsXML());
        retVal.addElement("comment").setText(this.getComment());
        return retVal;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        this.bsbObj.getParameterList().clearCompilationVarNames();
        int instrNum = compileData.addInstrument(this.bsbObj);
        return this.generateNotes(instrNum, startTime, endTime);
    }

    @Override
    public Sound deepCopy() {
        Sound sound = new Sound();
        sound.subjectiveDuration = this.subjectiveDuration;
        sound.startTime = this.startTime;
        sound.name = this.name;
        sound.backgroundColor = this.backgroundColor;
        sound.setComment(this.getComment());
        sound.setBlueSynthBuilder(this.bsbObj.deepCopy());
        return sound;
    }
}

