/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.jmask.Constant;
import blue.soundObject.jmask.Generator;
import blue.soundObject.jmask.Parameter;
import blue.soundObject.jmask.Utilities;
import blue.utility.NumberUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Field
implements ListModel {
    ArrayList<Parameter> parameters = new ArrayList();
    private transient Vector listListeners = null;

    public Field() {
        this(true);
    }

    private Field(boolean init) {
        if (init) {
            this.parameters.add(Parameter.create(new Constant()));
            this.parameters.add(Parameter.create(new Constant()));
            this.parameters.add(Parameter.create(new Constant()));
            this.parameters.get(0).setName("Instrument ID");
            this.parameters.get(1).setName("Start");
            this.parameters.get(2).setName("Duration");
        }
    }

    public Field(Field field) {
        for (Parameter param : field.parameters) {
            this.parameters.add(new Parameter(param));
        }
    }

    public static Field loadFromXML(Element data) throws Exception {
        Field field = new Field(false);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            if (!nodeName.equals("parameter")) continue;
            field.parameters.add(Parameter.loadFromXML(node));
        }
        return field;
    }

    public void pushUp(int index) {
        if (index > 0 && index < this.parameters.size()) {
            Parameter val = this.parameters.remove(index);
            this.parameters.add(index - 1, val);
            ListDataEvent lde = new ListDataEvent(this, 0, index - 1, index);
            this.fireContentsChangedEvent(lde);
        }
    }

    public void pushDown(int index) {
        if (index >= 0 && index < this.parameters.size() - 1) {
            Parameter val = this.parameters.remove(index + 1);
            this.parameters.add(index, val);
            ListDataEvent lde = new ListDataEvent(this, 0, index, index + 1);
            this.fireContentsChangedEvent(lde);
        }
    }

    public Element saveAsXML() {
        Element retVal = new Element("field");
        for (Parameter param : this.parameters) {
            retVal.addElement(param.saveAsXML());
        }
        return retVal;
    }

    public NoteList generateNotes(double duration, Random rnd) {
        NoteList nl = new NoteList();
        double xt = 0.0;
        int numFields = this.parameters.size();
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.getParameter(i).initialize(duration);
        }
        while (xt < duration) {
            Note n = Note.createNote(numFields);
            double p1 = this.getParameter(0).getValue(xt, rnd);
            p1 = p1 < 1.0 ? 1.0 : Utilities.round(p1, 0L);
            n.setPField(NumberUtilities.formatDouble(p1), 1);
            n.setPField(NumberUtilities.formatDouble(xt), 2);
            for (int i = 3; i < numFields + 1; ++i) {
                double val = this.getParameter(i - 1).getValue(xt, rnd);
                if (i == 3 && val < 0.0) {
                    n.setPField(NumberUtilities.formatDouble(-val), i);
                    n.setTied(true);
                    continue;
                }
                n.setPField(NumberUtilities.formatDouble(val), i);
            }
            double p2 = this.getParameter(1).getValue(xt, rnd);
            if (p2 == 0.0) {
                System.err.println("[JMask] - WARNING: p2 = 0 !");
            }
            xt += p2;
            nl.add(n);
        }
        return nl;
    }

    public Parameter getParameter(int index) {
        return this.parameters.get(index);
    }

    public Parameter removeParameter(int index) {
        Parameter retVal = this.parameters.remove(index);
        ListDataEvent lde = new ListDataEvent(this, 2, index, index);
        this.fireRemoveDataEvent(lde);
        return retVal;
    }

    public void addParameterBefore(int index, Generator gen) {
        Parameter param = Parameter.create(gen);
        this.parameters.add(index, param);
        ListDataEvent lde = new ListDataEvent(this, 1, index, index);
        this.fireAddDataEvent(lde);
    }

    public void addParameterAfter(int index, Generator gen) {
        Parameter param = Parameter.create(gen);
        this.parameters.add(index + 1, param);
        ListDataEvent lde = new ListDataEvent(this, 1, index + 1, index + 1);
        this.fireAddDataEvent(lde);
    }

    public void changeParameter(int index, Generator gen) {
        Parameter param = Parameter.create(gen);
        this.parameters.remove(index);
        this.parameters.add(index, param);
        ListDataEvent lde = new ListDataEvent(this, 0, index, index);
        this.fireContentsChangedEvent(lde);
    }

    @Override
    public int getSize() {
        return this.parameters.size();
    }

    public Object getElementAt(int index) {
        return this.parameters.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (this.listListeners == null) {
            this.listListeners = new Vector();
        }
        this.listListeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (this.listListeners != null) {
            this.listListeners.remove(l);
        }
    }

    private void fireAddDataEvent(ListDataEvent lde) {
        if (this.listListeners == null) {
            return;
        }
        for (ListDataListener listener : new Vector(this.listListeners)) {
            listener.intervalAdded(lde);
        }
    }

    private void fireRemoveDataEvent(ListDataEvent lde) {
        if (this.listListeners == null) {
            return;
        }
        for (ListDataListener listener : new Vector(this.listListeners)) {
            listener.intervalRemoved(lde);
        }
    }

    private void fireContentsChangedEvent(ListDataEvent lde) {
        if (this.listListeners == null) {
            return;
        }
        for (ListDataListener listener : new Vector(this.listListeners)) {
            listener.contentsChanged(lde);
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

