/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import electric.xml.Element;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TablePoint {
    private double time = 0.0;
    private double value = 0.5;
    private transient Vector listeners = null;
    private transient ChangeEvent changeEvent = null;

    public TablePoint() {
    }

    public TablePoint(TablePoint tp) {
        this.time = tp.time;
        this.value = tp.value;
    }

    public static TablePoint loadFromXML(Element data) {
        TablePoint tp = new TablePoint();
        tp.setTime(Double.parseDouble(data.getAttributeValue("time")));
        tp.setValue(Double.parseDouble(data.getAttributeValue("value")));
        return tp;
    }

    public Element saveAsXML() {
        Element retVal = new Element("point");
        retVal.setAttribute("time", Double.toString(this.getTime()));
        retVal.setAttribute("value", Double.toString(this.getValue()));
        return retVal;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setLocation(double time, double value) {
        this.time = time;
        this.value = value;
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        this.fireChangeEvent(this.changeEvent);
    }

    public void addChangeListener(ChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(pcl);
    }

    public void removeChangeListener(ChangeListener pcl) {
        if (this.listeners != null) {
            this.listeners.remove(pcl);
        }
    }

    public void fireChangeEvent(ChangeEvent pce) {
        if (this.listeners != null) {
            for (ChangeListener pcl : this.listeners) {
                pcl.stateChanged(pce);
            }
        }
    }
}

