/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.utilities.jconsole;

import blue.ui.utilities.jconsole.CommandHistory;
import blue.ui.utilities.jconsole.JConsoleDelegate;
import blue.ui.utilities.jconsole.streams.ConsoleInputStream;
import blue.ui.utilities.jconsole.streams.ConsoleOutputStream;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class JConsole
extends JTextArea
implements KeyListener {
    private static final long serialVersionUID = -5866169869353990380L;
    public final Reader in;
    public final Writer out;
    public final Writer err;
    private CommandHistory history;
    int editStart;
    boolean running;
    private ConsoleFilter filter;
    private Thread pythonThread;
    private JConsoleDelegate delegate = null;
    JPopupMenu menu = new JPopupMenu();

    public JConsole() {
        this.in = new ConsoleInputStream(this);
        this.out = new ConsoleOutputStream(this);
        this.err = new ConsoleOutputStream(this);
        this.history = new CommandHistory();
        this.setTabSize(4);
        this.addKeyListener(this);
        this.filter = new ConsoleFilter(this);
        ((AbstractDocument)this.getDocument()).setDocumentFilter(this.filter);
        this.setText("Jython Interactive Console\r\n>>> ");
        this.getCaret().setDot(this.editStart);
        AbstractAction clearAction = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JConsole.this.setText(">>>");
            }
        };
        clearAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.menu.add(clearAction);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JConsole.this.menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void setDelegate(JConsoleDelegate delegate) {
        this.delegate = delegate;
        if (this.delegate != null) {
            this.setText(delegate.getPrompt());
        }
    }

    @Override
    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean updateEditStart) {
        this.filter.useFilters = false;
        super.setText(text);
        this.filter.useFilters = true;
        if (updateEditStart) {
            this.editStart = text.length();
        }
        this.getCaret().setDot(text.length());
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int selectStart;
        int shortcutKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((e.getModifiers() & shortcutKey) == shortcutKey) {
            if (e.getKeyCode() == 76 && !e.isShiftDown() && !e.isAltDown()) {
                this.setText(">>>");
                e.consume();
            } else if (e.getKeyCode() == 65 && !e.isShiftDown() && !e.isAltDown()) {
                if (this.getSelectionStart() >= this.editStart && (this.getSelectionStart() != this.editStart || this.getSelectionEnd() != this.getText().length())) {
                    this.setSelectionStart(this.editStart);
                    this.setSelectionEnd(this.getText().length());
                    e.consume();
                }
            } else if (e.getKeyCode() == 40 && !e.isShiftDown() && !e.isAltDown()) {
                StringBuilder temp = new StringBuilder(this.getText());
                temp.delete(this.editStart, temp.length());
                temp.append(this.history.getNextCommand());
                this.setText(temp.toString(), false);
                e.consume();
            } else if (e.getKeyCode() == 38 && !e.isShiftDown() && !e.isAltDown()) {
                StringBuilder temp = new StringBuilder(this.getText());
                temp.delete(this.editStart, temp.length());
                temp.append(this.history.getPrevCommand());
                this.setText(temp.toString(), false);
                e.consume();
            }
        } else if (e.getKeyCode() == 10) {
            if (!e.isShiftDown() && !e.isAltDown()) {
                if (this.running) {
                    StringBuilder text = new StringBuilder(this.getText());
                    text.append(System.getProperty("line.separator"));
                    String command = text.substring(this.editStart);
                    this.setText(text.toString());
                    ((ConsoleInputStream)this.in).addText(command);
                } else {
                    StringBuilder text = new StringBuilder(this.getText());
                    String command = text.substring(this.editStart);
                    text.append(System.getProperty("line.separator"));
                    this.setText(text.toString());
                    this.history.add(command);
                    this.pythonThread = new Thread(new JConsoleCommandRunner(command));
                    this.pythonThread.setDaemon(true);
                    this.pythonThread.start();
                }
                e.consume();
            } else if (!e.isAltDown()) {
                StringBuilder text = new StringBuilder(this.getText());
                if (this.getSelectedText() != null) {
                    text.delete(this.getSelectionStart(), this.getSelectionEnd());
                }
                text.insert(this.getSelectionStart(), System.getProperty("line.separator"));
                this.setText(text.toString(), false);
            }
        } else if (e.getKeyCode() == 36 && (selectStart = this.getSelectionStart()) > this.editStart) {
            for (int i = this.editStart; i < selectStart; ++i) {
                if (this.getText().charAt(i) != '\n') continue;
                return;
            }
            if (e.isShiftDown()) {
                this.getCaret().moveDot(this.editStart);
            } else {
                this.getCaret().setDot(this.editStart);
            }
            e.consume();
        }
    }

    public void finalize() {
        if (this.running) {
            this.pythonThread.stop();
            this.pythonThread.destroy();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private class JConsoleCommandRunner
    implements Runnable {
        private String commands;

        public JConsoleCommandRunner(String commands) {
            this.commands = commands;
        }

        @Override
        public void run() {
            JConsole.this.running = true;
            try {
                JConsole.this.delegate.processCommands(this.commands, JConsole.this.in, JConsole.this.out, JConsole.this.err);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StringBuilder text = new StringBuilder(JConsole.this.getText());
            text.append(JConsole.this.delegate.getPrompt());
            JConsole.this.setText(text.toString());
            JConsole.this.running = false;
        }
    }

    private class ConsoleFilter
    extends DocumentFilter {
        private JConsole console;
        public boolean useFilters;

        public ConsoleFilter(JConsole console) {
            this.console = console;
            this.useFilters = true;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (this.useFilters) {
                if (this.console.getSelectionStart() >= this.console.editStart) {
                    fb.insertString(offset, string, attr);
                } else {
                    fb.insertString(this.console.getText().length(), string, attr);
                    this.console.getCaret().setDot(this.console.getText().length());
                }
            } else {
                fb.insertString(offset, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (this.useFilters) {
                if (this.console.getSelectionStart() >= this.console.editStart) {
                    fb.replace(offset, length, text, attrs);
                } else {
                    fb.insertString(this.console.getText().length(), text, attrs);
                    this.console.getCaret().setDot(this.console.getText().length());
                }
            } else {
                fb.replace(offset, length, text, attrs);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            if (this.useFilters) {
                if (offset > this.console.editStart) {
                    fb.remove(offset, length);
                } else {
                    fb.remove(this.console.editStart, length - (this.console.editStart - offset));
                    this.console.getCaret().setDot(this.console.editStart);
                }
            } else {
                fb.remove(offset, length);
            }
        }
    }
}

