/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.patterns.core;

import blue.CompileData;
import blue.score.ScoreObject;
import blue.score.layers.Layer;
import blue.score.layers.patterns.core.PatternData;
import blue.soundObject.GenericScore;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.utility.ObjectUtilities;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatternLayer
implements Layer {
    private SoundObject soundObject;
    private String name = "";
    private boolean muted = false;
    private boolean solo = false;
    private PatternData patternData;
    private transient Vector<PropertyChangeListener> propListeners = null;

    public PatternLayer() {
        this.soundObject = new GenericScore();
        this.soundObject.setStartTime(0.0);
        this.soundObject.setSubjectiveDuration(4.0);
        this.soundObject.setTimeBehavior(2);
        this.patternData = new PatternData();
    }

    public PatternLayer(PatternLayer pl) {
        this.name = pl.name;
        this.muted = pl.muted;
        this.solo = pl.solo;
        this.soundObject = pl.soundObject.deepCopy();
        this.patternData = new PatternData(pl.patternData);
    }

    public SoundObject getSoundObject() {
        return this.soundObject;
    }

    public void setSoundObject(SoundObject soundObject) {
        this.soundObject = soundObject;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        String string = this.name = name == null ? "" : name;
        if (!this.name.equals(oldName)) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "name", oldName, name));
        }
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    public boolean isSolo() {
        return this.solo;
    }

    public void setSolo(boolean solo) {
        this.solo = solo;
    }

    public PatternData getPatternData() {
        return this.patternData;
    }

    public Element saveAsXML() {
        Element retVal = new Element("patternLayer");
        if (this.soundObject != null) {
            retVal.addElement(this.soundObject.saveAsXML(null));
        }
        retVal.addElement(this.patternData.saveAsXML());
        retVal.setAttribute("name", this.getName());
        retVal.setAttribute("muted", Boolean.toString(this.isMuted()));
        retVal.setAttribute("solo", Boolean.toString(this.isSolo()));
        return retVal;
    }

    public static PatternLayer loadFromXML(Element data) {
        PatternLayer layer = new PatternLayer();
        layer.setName(data.getAttributeValue("name"));
        layer.setMuted(Boolean.valueOf(data.getAttributeValue("muted")));
        layer.setSolo(Boolean.valueOf(data.getAttributeValue("solo")));
        Elements nodes = data.getElements();
        int heightIndex = -1;
        boolean oldTimeStateValuesFound = false;
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            if ("soundObject".equals(nodeName)) {
                try {
                    layer.setSoundObject((SoundObject)ObjectUtilities.loadFromXML((Element)node, null));
                }
                catch (Exception ex) {
                    Logger.getLogger(PatternLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if (!nodeName.equals("patternData")) continue;
            layer.patternData = PatternData.loadFromXML(node);
        }
        return layer;
    }

    void clearListeners() {
    }

    NoteList generateForCSD(CompileData compileData, double startTime, double endTime, int patternBeatsLength) throws SoundObjectException {
        NoteList notes = new NoteList();
        this.soundObject.setStartTime(0.0);
        NoteList tempNotes = this.soundObject.generateForCSD(compileData, -1.0, -1.0);
        for (int currentIndex = (int)(startTime / (double)patternBeatsLength); currentIndex < this.patternData.getSize(); ++currentIndex) {
            if (!this.patternData.isPatternSet(currentIndex)) continue;
            double time = currentIndex * patternBeatsLength;
            NoteList copy = new NoteList(tempNotes);
            ScoreUtilities.setScoreStart((NoteList)copy, (double)time);
            notes.addAll((Collection)copy);
        }
        return notes;
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.propListeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.propListeners) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propListeners == null) {
            this.propListeners = new Vector();
        }
        if (this.propListeners.contains(pcl)) {
            return;
        }
        this.propListeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propListeners == null) {
            return;
        }
        this.propListeners.remove(pcl);
    }

    public int getLayerHeight() {
        return 22;
    }

    public boolean accepts(ScoreObject object) {
        return false;
    }

    public boolean contains(ScoreObject object) {
        return false;
    }

    public boolean remove(ScoreObject object) {
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public void clearScoreObjects() {
    }

    public PatternLayer deepCopy() {
        return new PatternLayer(this);
    }
}

